layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in float v_time;
layout (location = 3) in vec3 v_world_pos;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    float g_chart_time;
    vec4 color;
    vec4 color2;
    vec4 params;
    vec3 light_dir;
    vec3 depth_color;
    vec3 depth_bias;
};

float alpha_of_depth(float alpha) {
    float m = -depth_bias.y * 0.1;
    float z = clamp((v_world_pos.y - m) * depth_bias.x * 10 + m, 0, 1);
    float a = alpha * z;
    a = a*a;
    return a;
}

vec3 fog_of_depth(vec3 color) {
    float m = alpha_of_depth(1.0);
    return mix(color, depth_color, 1-m);
}


void main() {
    vec4 c = color + (color2 - color) * pow(v_time, color2.w);
    vec3 light_dir_norm = normalize(light_dir);
    float intensity = max(dot(normalize(v_normal), light_dir_norm), 0);
    float specular = max(pow(dot(normalize(v_normal), light_dir_norm), params.x), 0.0);
    vec4 e = vec4(depth_color,0) + intensity * c + specular * color.w;
    vec3 d = fog_of_depth(e.rgb);
    f_color = vec4(d, e.a);
}
