layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;
layout (location = 2) out vec3 v_world_pos;


layout (set = 0, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_world_from_model;

    float size;
    vec2 tex_start;
    vec2 tex_size;
};

void main() {
    vec3 pos = a_position * size * vec3(tex_size.x, 1, tex_size.y);
    gl_Position = g_projection_from_model * vec4(pos, 1.0);
    v_uv = a_uv * tex_size + tex_start;
    v_normal = mat3(g_camera_from_model) * a_normal;
    v_world_pos = (g_world_from_model * vec4(pos, 1)).xyz;
}