layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;
layout (location = 2) out float v_time;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    float g_app_time;
    float extrude;
    float g_instance_count;
    vec4 A;
    vec3 pos_offset;

};

struct Point {
    vec4 pos;
    vec4 normal;
    vec4 tangent;
};

layout (set = 0, binding = 1) buffer Attractor {
    Point points[];
} attractor;

void main() {
    float coverage = A.x;
    float scale = A.y;

    vec3 pos = a_position;

    float id = (pos.y + 1) * 0.5 * coverage; //gl_InstanceIndex / g_instance_count * coverage;
    v_time = id;

//    float attractor_count = attractor.pos.length();
    int attractor_index = int(100000  * id);
    Point p = attractor.points[attractor_index];

    vec3 normal = p.normal.xyz;
    vec3 tangent = p.tangent.xyz;
    vec3 binormal = cross(normal, tangent);
    mat3 rot_mat = mat3(normal, tangent, binormal);

    vec3 local_pos = normalize(vec3(pos.x, 0, pos.z));
    vec3 new_local_pos = rot_mat * local_pos;
    vec3 new_pos = p.pos.xyz * scale + new_local_pos * extrude + pos_offset * A.y;
    vec3 new_normal = new_local_pos; // rot_mat * a_normal;

//    vec3 move = vec3(sin(id * 0.1) * 0.5, sin(id*0.3)*0.4, cos(id * 0.1) * 0.5);


//    float t = g_app_time;
//    vec3 rot = vec3(t*0.2, t*0.8, t*0.4);
//    mat4 tr_mat = translate(position *10.1);

//    vec3 pos = a_position + a_normal * extrude * 0.25;

//    gl_Position = g_projection_from_model * tr_mat * vec4(pos, 1.0);
    gl_Position = g_projection_from_model * vec4(new_pos, 1.0);
    v_uv = a_uv;

    v_normal = (g_camera_from_model * vec4(new_normal, 0.0)).xyz;
//    v_normal = a_normal;
}