layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out float v_focus;

layout (set = 0, binding = 0) uniform Uniforms {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    vec3 extrude;
    vec2 g_pixel_size;
    float g_aspect_ratio;
    float g_app_time;
    vec3 amplitude;
    float seed;
    vec4 factor_1;
    vec4 factor_2;
    vec4 factor_3;
    vec4 comb;
    vec4 movement;
    float focus_distance;
    float focus_depth;
    vec2 movement_time;
};

vec3 fpos(vec4 f, float rnd, float at) {
    float id = (gl_InstanceIndex + seed) * rnd;
    vec3 t = vec3(at, at*f.w+id, at*f.w+id*0.0123);
    vec3 p = sin(t * f.x + id) + cos(t * f.y + id * 0.03423) * sin(t * f.z + id * 0.013423);
    return p;
}

void main() {
    float id = gl_InstanceIndex + seed;
    float at = g_app_time / 10.;

    vec3 pos = fpos(factor_1, 0.01, at) * comb.x;
    pos += fpos(factor_2, 0.0234234, at) * comb.y;
    pos += fpos(factor_3, 0.0423, at) * comb.z;
    //pos *= amplitude.xxy;

    float box = ceil(movement.y * 10);
    vec2 pd = pos.xy * amplitude.z + movement.xw * movement_time + id * movement.z;
    pos.xy = fract(pd / box) * box - box/2;
    pos *= amplitude.xxy;

    vec4 transformed_pos = g_projection_from_model * vec4(pos,1);

    float off = (abs(transformed_pos.w - focus_distance * 10) * focus_depth / 10);
    v_focus = off;

    float ex = extrude.x + min(off, extrude.y) * extrude.z;

    vec2 corner_pos = (a_uv*2-1) * vec2(1, -1);
    transformed_pos.xy += corner_pos * ex * vec2(1, g_aspect_ratio);
    gl_Position = transformed_pos;
    v_uv = a_uv;
}