layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec2 v_uv_min;
layout (location = 2) out vec2 v_uv_max;

layout (set = 0, binding = 0) uniform Uniforms {
    float scale;
    vec2 move;
    vec2 tex_start;
    vec2 tex_size;
    vec2 padding;
};

void main() {
    vec2 c = vec2(a_position.x, -a_position.z);
    vec2 ipos = c * (tex_size + padding);
    vec2 pos = ipos * scale + move;

    gl_Position = vec4(pos, 0, 1);
    float correction = 1.2;
//    v_uv = a_uv * tex_size + tex_start + padding * c * tex_size /scale* vec2(2, correction);
    v_uv = tex_start + a_uv * tex_size + padding * c / 2;
    v_uv_min = tex_start;
    v_uv_max = tex_start + tex_size;

}