org 100h
start:
	mov	al, 13h
	int	10h
	push	word 0a000h
	pop	es

; init midi
	mov	al, 3Fh	        ; set UART mode - command
	mov	dx, 331h	; MIDI Control Port
	out	dx, al	        ; send !

; init timer
	mov	ax, 0x251c
	mov	dx, timer
	int	21h
	mov	al, 1193182/256/10/4
	out	0x40, al
	out	0x40, al

mainloop:

ploop:
; rrrola
; (x, y) => (dl, dh)
; then center on 0 (-128, -100) -> (127, 99)
	mov	ax, 0xcccd
	mul	di
	sub	dh, 100
	sub	dl, 128

	push	dx

	push	dx

; cx = -256 -> 255 -> 256
	mov	cx, bp
	shl	cx, 8
	jns	posit1
	not	cx
posit1: sar	cx, 6
	dec	ch

; rotozoom with cx
	movsx	ax, dh
	movsx	bx, dl
	imul	cx
	imul	bx, cx
	pop	dx
	add	dh, bh
	sub	dl, ah

	push	dx

; cl = 0xff is the pixel min
; ch = 2 is the "twice" loop counter
	mov	cx, 0x2ff

; (dl, dh) *= 0.75 (zoom x1.5, close enough to sqrt(2))
	mov	bx, dx
	sar	bl, 2
	sar	bh, 2
	sub	dx, bx

twice:

; abs(dl), abs(dh)
	or	dh, dh
	jns	nabs1
	neg	dh
nabs1:	or	dl, dl
	jns	nabs2
	neg	dl
nabs2:

; star
; al = dh / 4 + dl
; ah = dl / 4 + dh
	mov	ax, dx
	shr	al, 2
	shr	ah, 2
	rol	ax, 8
	add	ax, dx

; mix star
; cl = min(cl, ah, al)
	cmp	cl, al
	jb	min1
	mov	cl, al
min1:	cmp	cl, ah
	jb	min2
	mov	cl, ah
min2:

; restore (x, y) to (dl, dh)
	pop	dx

; loop end
	dec	ch
	jz	star_done

; (dl, dh) rotate by 45 degrees
	sar	dl, 1
	sar	dh, 1
	mov	bx, dx
	add	dl, bh
	sub	dh, bl

	jmp	twice

star_done:

; ball
	mov	al, dl
	mov	bl, dl
	imul	bl
	mov	si, ax
	mov	al, dh
	mov	bl, dh
	imul	bl
	add	ax, si
	shr	ax, 7

; mix ball
	cmp	al, 90
	ja	nomin3
	cmp	cl, al
	jb	min3
nomin3	mov	cl, al
min3:
	add	cl, 16
	cmp	cl, 32
	jb	ball
; background
	mov	cl, 0x28
	mov	al, dh
	sub	ax, bp
	and	al, dl
	shr	al, 4
	and	al, 3
	add	cl, al
ball:
	mov	al, cl

	stosb

; check for <ESC>, loop
	in	al, 60h
	dec	al
	jnz	mainloop
	mov	ax, 03h
	int	10h
	ret

; **********************

; interrupt handler, called at 40 Hz
timer:
	inc	bp              ; increase frame counter
	pusha	                ; backup registers (dx, si, cx, eax used)

; play a note every 4 ticks: 10 Hz, because MAX300 ;)
	test	bp, 3
	jnz	nomuse

; prepare outsb, for MIDI data
	mov	dx, 330h
	mov	si, dsound

; rhythm
	mov	cx, bp
	shr	cl, 2
	mov	eax, 0xadadada8 ; rhythm pattern
	shl	eax, cl
	jns	nodrum

; play drum, but only in rhythm
	outsb
	outsb
	outsb

; play bass
nodrum: mov	cx, 5
	rep outsb

; end of interrupt handler
nomuse:	popa
	iret

; **********************

; MIDI commands
dsound:	db	0xc0, 39        ; set ch0 instrument to 39 (synth bass)
        db	0x90, 35, 63    ; play ch0, note 35, vol 63
        db	0x99, 35, 127   ; play ch9 (drums), note 35 (kick), vol 127 (max)
