; 3:03
; 256b entry for Revision 2023 from T$
; runs on MS-DOS / FreeDOS / DosBOX (cycles = max or at least high enough for > 18 fps) 
; featuring famous NULLTRASOUND technology (first time under DOS!)
; In memory of Brullwurfel
; Tribute to the famous masterpiece by Jimmy Crate

org 100h

push word [fs:0x46c]
pop word [100h]

mov al,13h
int 10h

schleife:

; visuals

cmp di,320*8*5
jnz skiptext

push bp
;INT 10 - VIDEO - WRITE STRING (AT and later,EGA)
mov ax,1300h ;AH = 13h ;AL = write mode	   bit 0: update cursor after writing, bit 1: string contains alternating characters and attributes
mov bx,bp ;BH = page number ;BL = attribute if string contains only characters
 mov bp,text1 ;	ES:BP -> string to write
 mov cl,4 ;CX = number of characters in string
test bl, 3*64
je writetext
 mov bp,text2 ;	ES:BP -> string to write
 mov cl,23 ;CX = number of characters in string
;test bl, 7*32
jp writetext
 mov bp,text3 ;	ES:BP -> string to write
 mov cl,16 ;CX = number of characters in string
writetext:
mov dx,cx
shr dx,1
neg dl
add dx,2*256+20 ;DH,DL = row,column at which to start writing
 push cs
 pop es
 int 10h
pop bp
skiptext:

push word 0a000h - 70 ;modified to center to 160,100
pop es


mov bx,bp
shr bx,2
sar bl,1
makeabs:
neg bl
js makeabs
add bh,80

eyedist equ 24
eyeheight equ 32

tomatoendcolor equ 16
eyecolorend equ 31
mov dl, eyecolorend
mov si, 8*256

test bp,32+16+6
jnz noblink
 mov si,bp
 shl si,12
noblink:

;mov cx,16 ;eyes
call kugelding
jc passtschon
sub bx,eyedist*2
call kugelding
jc passtschon

mov dx,bp
;and dx,63
shr dx,6
xor dh,dh
add dx,tomatoendcolor
add bx,eyeheight*256+eyedist
mov si,192
;sphere
call kugelding
jc passtschon
 xor ax,ax
passtschon:

stosb

or di,di
jnz schleife

mov bp,[fs:0x46c]
sub bp,[100h]
cmp bp,(3*60+3)*182/10
jg ende

; sound

;out 42h,al ; set speaker freq
;out 42h,al
;not al
;out 61h,al ; enable speaker

; ui

in al,60h
; optional: check with dec instead of das for better dosbox compatibility:
dec al       ;das
jnz schleife ;jp schleife
;ret

kugelding: ; bh = yOffset, bl = xOffset, si = scale, dx = color offset, cx = maxdist^2
push dx
    mov ax,0xCCCD
    mul di        ; dh = y, dl.ah = x)

    xchg ax,dx
        mov dl, ah
add ax,bx
    imul al ; ax = x^2
        xchg ax,dx
sub al,bh
    imul al ; dx = x^2, ax = y^2
    add ax,dx
mul si
xchg ax,dx

pop dx
cmp ax,16
pushf
    ;dithering
    mov cx,di
	imul cx,bp
    xor cl,ch
    and cx,15

    cmp al,cl
    mov ax,dx
	js nodrop
	xor ax,ax
	nodrop:
popf
ende:
ret

text1: db "3:03"
text2: db "In Memoriam Brullwurfel"
text3: db "Listen Carefully"
