//***************************************************************************
// "editor.h"
// Declarations for the level editor
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef EDITOR_H
#define EDITOR_H

// Required headers
#include <stdint.h>
#include "level.h"

// Information contained in a tile in the map
typedef struct {
   uint8_t coll;           // Collision
   uint8_t obj;            // Object
   uint8_t flags;          // Flags
} MapTile;

// Data of the map being currently edited
typedef struct {
   unsigned width;         // Width in tiles
   unsigned height;        // Height in tiles
   unsigned spawn_x;       // Spawn point X coordinate
   unsigned spawn_y;       // Spawn point Y coordinate
   Theme theme;            // Level theme
   MapTile **data;         // Map data
} Map;

// Flags for each tile in the map
#define MAPFLAG_FLIP       0x01     // Flip object
#define MAPFLAG_RESERVED   0xFE     // Reserved flags

// Function prototypes
void init_editor(void);
void run_editor(void);
void draw_editor(void);
void deinit_editor(void);
const Map *get_editor_map(void);

#endif
