//***************************************************************************
// "enemies.h"
// Code for enemy objects.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef ENEMIES_H
#define ENEMIES_H

// Required headers
#include "objects.h"

// Enemy count
extern unsigned num_enemies;

// Function prototypes
void load_enemies(void);
void unload_enemies(void);
void init_flamer(Object *);
void run_flamer(Object *);
void init_sprayer(Object *);
void run_sprayer(Object *);
void init_turret(Object *);
void run_turret(Object *);
void init_roller(Object *);
void run_roller(Object *);
void run_grabber(Object *);
void init_spider(Object *);
void run_spider(Object *);
void init_heater(Object *);
void run_heater(Object *);
void init_bomb(Object *);
void run_bomb(Object *);
void destroy_enemy(Object *);

#endif
