//***************************************************************************
// "ingame.h"
// Declarations for the in-game mode.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef INGAME_H
#define INGAME_H

// Required headers
#include <stdint.h>
#include "settings.h"
#include "sound.h"

// Information for the camera
typedef struct {
   int32_t x;              // Horizontal coordinate
   int32_t y;              // Vertical coordinate
   int32_t limit_left;     // Left limit of the visible window
   int32_t limit_right;    // Right limit of the visible window
   int32_t limit_top;      // Top limit of the visible window
   int32_t limit_bottom;   // Bottom limit of the visible window
   int32_t offset_x;       // Horizontal offset
   int32_t offset_y;       // Vertical offset
   int32_t auto_offset;    // Automatic vertical offset
   unsigned quake;         // Quake timer
} Camera;
extern Camera camera;

// Generic animation counter
extern uint32_t game_anim;

// Function prototypes
void init_ingame(void);
void run_ingame(void);
void draw_ingame(void);
void deinit_ingame(void);
int32_t speed_to_int(int32_t);
void reset_random(void);
uint16_t get_random(uint16_t);
void apply_quake(unsigned);
void set_map_switch(unsigned);
int get_map_switch(unsigned);
void finish_level(void);
void play_ingame_bgm(BgmID);
void toggle_pause(void);
Difficulty get_difficulty(void);

#endif
