//***************************************************************************
// "parser.h"
// Parser definitions.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef PARSER_H
#define PARSER_H

// Required headers
#include <stddef.h>
#include <stdint.h>

// Where parsed arguments are stored
typedef struct {
   size_t count;        // Number of arguments
   char **list;         // Argument list
} Args;

// Function prototypes
Args *parse_args(const char *);
void add_arg(Args *, const char *);
void free_args(Args *);
int is_integer(const char *);
int is_uinteger(const char *);
int is_valid_id(char *);
int is_color(const char *);

#endif
