//***************************************************************************
// "physics.h"
// Definitions for the physics stuff.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef PHYSICS_H
#define PHYSICS_H

// Required headers
#include <stdint.h>
#include "objects.h"

// Function prototypes
void apply_physics(Object *);
void accelerate_object(Object *, int32_t, int32_t);
void decelerate_object(Object *, int32_t);
void set_hitbox(Object *, int32_t, int32_t, int32_t, int32_t);
void refresh_hitbox(Object *);
int collision(const Object *, const Object *);
int can_climb(const Object *);

#endif
