//***************************************************************************
// "player.h"
// Code for player objects.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef PLAYER_H
#define PLAYER_H

// Required headers
#include <stdlib.h>
#include "objects.h"

// Function prototypes
void load_player(void);
void unload_player(void);
void init_player(Object *);
void run_player(Object *);
void hurt_player(Object *, int32_t);
void kill_player(Object *);
void do_hammer_bounce(Object *);
void reset_anger(void);
void init_hsonar(Object *);
void run_hsonar(Object *);
void init_vsonar(Object *);
void run_vsonar(Object *);

#endif
