//***************************************************************************
// "recording.h"
// Movie recording code.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

#ifndef RECORDING_H
#define RECORDING_H

// Required headers
#include "sound.h"

// Function prototypes
void start_recording(void);
void update_recording(void);
void update_audiovideo_recording(const uint8_t *);
void stop_recording(void);
int is_recording(void);
void draw_recording_hud(void);
void record_bgm(BgmID);
void record_sfx(SfxID, int32_t, int32_t, uint16_t, uint64_t, uint32_t);

#endif
