//***************************************************************************
// "tables.c"
// Look-up tables for various calculations.
//---------------------------------------------------------------------------
// Sol engine
// Copyright ©2015, 2016 Azura Sun
//
// This file is part of Sol.
//
// Sol is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// Sol is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along
// with Sol. If not, see <http://www.gnu.org/licenses/>.
//***************************************************************************

// Required headers
#include <stdint.h>

//***************************************************************************
// Sines look-up table
//---------------------------------------------------------------------------
// Values are stored as 8.8 fixed comma, and thereby they range from -0x100
// (-1) to 0x100 (1). Angles are specified from 0x00 to 0xFF (with 0x100
// being a full circle).
//
// We're using this instead of sin() to have more predictable results
// (floating point introduces rounding errors, may be different depending on
// the processor, etc.). Also so the angle is easier to specify (no need to
// mess with radians).
//***************************************************************************

int16_t sines[0x100] = {
      0,    6,   12,   18,   25,   31,   37,   43,      // 0x00..0x07
     50,   56,   62,   68,   74,   80,   86,   92,      // 0x08..0x0F
     98,  104,  109,  115,  121,  126,  132,  137,      // 0x10..0x17
    142,  147,  153,  158,  163,  167,  172,  177,      // 0x18..0x1F
    181,  186,  190,  194,  198,  202,  206,  210,      // 0x20..0x27
    213,  217,  220,  223,  226,  229,  232,  234,      // 0x28..0x2F
    237,  239,  241,  244,  245,  247,  249,  250,      // 0x30..0x37
    252,  253,  254,  255,  255,  256,  256,  256,      // 0x38..0x3F
    256,  256,  256,  256,  255,  255,  254,  253,      // 0x40..0x47
    252,  250,  249,  247,  245,  244,  241,  239,      // 0x48..0x4F
    237,  234,  232,  229,  226,  223,  220,  217,      // 0x50..0x57
    213,  210,  206,  202,  198,  194,  190,  186,      // 0x58..0x5F
    181,  177,  172,  167,  163,  158,  153,  147,      // 0x60..0x67
    142,  137,  132,  126,  121,  115,  109,  104,      // 0x68..0x6F
     98,   92,   86,   80,   74,   68,   62,   56,      // 0x70..0x77
     50,   43,   37,   31,   25,   18,   12,    6,      // 0x78..0x7F
      0,   -6,  -12,  -18,  -25,  -31,  -37,  -43,      // 0x80..0x87
    -50,  -56,  -62,  -68,  -74,  -80,  -86,  -92,      // 0x88..0x8F
    -98, -104, -109, -115, -121, -126, -132, -137,      // 0x90..0x97
   -142, -147, -153, -158, -163, -167, -172, -177,      // 0x98..0x9F
   -181, -186, -190, -194, -198, -202, -206, -210,      // 0xA0..0xA7
   -213, -217, -220, -223, -226, -229, -232, -234,      // 0xA8..0xAF
   -237, -239, -241, -244, -245, -247, -249, -250,      // 0xB0..0xB7
   -252, -253, -254, -255, -255, -256, -256, -256,      // 0xB8..0xBF
   -256, -256, -256, -256, -255, -255, -254, -253,      // 0xC0..0xC7
   -252, -250, -249, -247, -245, -244, -241, -239,      // 0xC8..0xCF
   -237, -234, -232, -229, -226, -223, -220, -217,      // 0xD0..0xD7
   -213, -210, -206, -202, -198, -194, -190, -186,      // 0xD8..0xDF
   -181, -177, -172, -167, -163, -158, -153, -147,      // 0xE0..0xE7
   -142, -137, -132, -126, -121, -115, -109, -104,      // 0xE8..0xEF
    -98,  -92,  -86,  -80,  -74,  -68,  -62,  -56,      // 0xF0..0xF7
    -50,  -43,  -37,  -31,  -25,  -18,  -12,   -6       // 0xF8..0xFF
};

//***************************************************************************
// Cosines look-up table
// See the sines table comments for more details
//***************************************************************************

int16_t cosines[0x100] = {
    256,  256,  256,  256,  255,  255,  254,  253,      // 0x00..0x07
    252,  250,  249,  247,  245,  244,  241,  239,      // 0x08..0x0F
    237,  234,  232,  229,  226,  223,  220,  217,      // 0x10..0x17
    213,  210,  206,  202,  198,  194,  190,  186,      // 0x18..0x1F
    181,  177,  172,  167,  163,  158,  153,  147,      // 0x20..0x27
    142,  137,  132,  126,  121,  115,  109,  104,      // 0x28..0x2F
     98,   92,   86,   80,   74,   68,   62,   56,      // 0x30..0x37
     50,   43,   37,   31,   25,   18,   12,    6,      // 0x38..0x3F
      0,   -6,  -12,  -18,  -25,  -31,  -37,  -43,      // 0x40..0x47
    -50,  -56,  -62,  -68,  -74,  -80,  -86,  -92,      // 0x48..0x4F
    -98, -104, -109, -115, -121, -126, -132, -137,      // 0x50..0x57
   -142, -147, -153, -158, -163, -167, -172, -177,      // 0x58..0x5F
   -181, -186, -190, -194, -198, -202, -206, -210,      // 0x60..0x67
   -213, -217, -220, -223, -226, -229, -232, -234,      // 0x68..0x6F
   -237, -239, -241, -244, -245, -247, -249, -250,      // 0x70..0x77
   -252, -253, -254, -255, -255, -256, -256, -256,      // 0x78..0x7F
   -256, -256, -256, -256, -255, -255, -254, -253,      // 0x80..0x87
   -252, -250, -249, -247, -245, -244, -241, -239,      // 0x88..0x8F
   -237, -234, -232, -229, -226, -223, -220, -217,      // 0x90..0x97
   -213, -210, -206, -202, -198, -194, -190, -186,      // 0x98..0x9F
   -181, -177, -172, -167, -163, -158, -153, -147,      // 0xA0..0xA7
   -142, -137, -132, -126, -121, -115, -109, -104,      // 0xA8..0xAF
    -98,  -92,  -86,  -80,  -74,  -68,  -62,  -56,      // 0xB0..0xB7
    -50,  -43,  -37,  -31,  -25,  -18,  -12,   -6,      // 0xB8..0xBF
      0,    6,   12,   18,   25,   31,   37,   43,      // 0xC0..0xC7
     50,   56,   62,   68,   74,   80,   86,   92,      // 0xC8..0xCF
     98,  104,  109,  115,  121,  126,  132,  137,      // 0xD0..0xD7
    142,  147,  153,  158,  163,  167,  172,  177,      // 0xD8..0xDF
    181,  186,  190,  194,  198,  202,  206,  210,      // 0xE0..0xE7
    213,  217,  220,  223,  226,  229,  232,  234,      // 0xE8..0xEF
    237,  239,  241,  244,  245,  247,  249,  250,      // 0xF0..0xF7
    252,  253,  254,  255,  255,  256,  256,  256       // 0xF8..0xFF
};
