# Synth85

A music replayer for [KC 85](https://wikipedia.org/wiki/KC_85) computers.

## Short description

Unlike other music software for KC 85, this is a module based replayer known from Sound-/Protracker modules.
Because it doesn't deal with samples it's more dedicated for playing chip tunes.

## How to build

simply type

    make

(You will need [z80asm](https://www.nongnu.org/z80asm/) for this.)

As result a cassette image file named

SYNTH85.KCC

is generated that can be used in emulation or transferred to a real machine.

(see also: [z9001:kassettenformate](https://hc-ddr.hucki.net/wiki/doku.php/z9001:kassettenformate))

## Features

### General

* 2 channels (stereo at constant volume level or mono at 16 volume levels)
* playing sequence with 256 positions of 256 different patterns
* module title maximum length: 31 chars
* compatible with KC 85/2, 3 and 4.

### Supported replayer commands

00	Arpeggio  
01	Slide up  
02	Slide down  
03	Slide to note  
04	Vibrato  
05	Continue 'Slide to note', but also do Volume slide  
06	Continue 'Vibrato', but also do Volume slide  
0A	Volume slide
0B	Position jump
0C	Set volume  
0D	Pattern break (jumps always to first row)  
0F	Set speed (ticks per row only, no beats per minute)  

See also: [Protracker Module Effects](https://wiki.multimedia.cx/index.php?title=Protracker_Module#Effects)

## Synth85 Module format

**Bytes / Description**  

    32           Module’s Title (null terminated string)
    1            Song Attributes
    1            Position Count (0..255)
    0..255       Pattern Table (Size: Position Count Bytes)
    0..n*6*64    Pattern Data (6*64*Pattern Count)

### Song Attributes

**Bit / Description**

    0    volume control left   \ volume control bits combinable
    1    volume control right  /

    Bits 2 - 7 reserved

### Pattern data

**Bytes / Description**

    1    Note (0..84 = C-1..C-8)
    1    Effect command (00H..0FH)
    1    Effect parameters (hi/lo value)

channel 1 and channel 2 alternately, repeated 64 times

### File type and suffix

The KC 85 file type is "S85" and the recommended image file suffix is ".S85" or ".KCC".

## API

### Switches (constants to be defined)

Enable support for muting certain channels (tracker related)

    SYNTH85_CHANNEL_MUTE (0/1)

Call SYNTH85_TICK in custom interrupt

    SYNTH85_CUSTOM_INT (0/1)

Use master volume (includes 256 byte volume table)

    SYNTH85_MASTER_VOLUME (0/1)

Enable support for pattern repeat (tracker related)

    SYNTH85_PATTERN_REPEAT:	EQU	0

Play from RAM8

    SYNTH85_RAM8 (0/1)

Enable support for sound effects (game releated)

    SYNTH85_USE_SFX:	EQU	0

### Methods

Load given module, return error in A

    SYNTH85_LOAD ; (ModulePtr/HL) Error/A

Play currently loaded module

    SYNTH85_PLAY ; ()

Set playing position

    SYNTH85_SET ; (Position/A)

Stop currently playing module

    SYNTH85_STOP ; ()

Stop sound (custom interrupt)

    SYNTH85_SOUND_OFF ; ()

Call every 1/50 second (external interrupt) after module has been loaded

    SYNTH85_TICK ; ()

Set master volume (0..31)

    SYNTH85_SET_MASTER_VOLUME ; (Master volume/A)

### Variables

**values of the following variables can be read and are available after call of SYNTH85_PLAY or SYNTH85_TICK**

Event notification, acknowledge by setting to zero
	
    SYNTH85_NOTIFY
	
Module title
	
    SYNTH85_TITLE

Song length

    SYNTH85_POSCOUNT

Number of current pattern

    SYNTH85_PATTNUM

Current pattern position

    SYNTH85_PATTPOS

Current song position

    SYNTH85_SONGPOS

Song end

    SYNTH85_END

Pointer to current division for retrieving note value and parameters

    SYNTH85_DIV_PTR
