let CACHE_NAME = 'v15';

const assets = [
	//"/CutiveMono-Regular.ttf",
	//"/RockoUltraFLF.ttf",
	"/art/saw.glb",
	"/art/gameboy.glb",
	"/art/spiral_v4.glb",
	"/art/audio/MET_FLIPO_37b.mp3",
	"/art/audio/SVG_FLIPO_10.mp3",
	"/art/audio/saw.mp3",
	"/art/audio/sos.mp3",
	"/art/flipo-lines.png",
	"/art/spiral/spiral_brace_logo.png",
	"/art/spiral/spiral_dd.png",
	"/art/spiral/spiral_dd2.png",
	"/art/spiral/spiral_eye.png",
	"/art/spiral/spiral_happy.png",
	"/art/spiral/spiral_antares.gif",
	"/art/spiral/spiral_oxg1.gif",
	"/art/spiral/spiral_adn.png",
	"/art/spiral/spiral_birth_water.gif",
	"/art/spiral/spiral_contrast1.png",
	"/art/spiral/spiral_contrast2.png",
	"/art/spiral/spiral_cottage.gif",
	"/art/spiral/spiral_cuzco.gif",
	"/art/spiral/spiral_apex.gif",
	"/art/spiral/spiral_brace3.gif",
	"/art/spiral/spiral_christies.png",
	"/art/spiral/spiral_replicants.png",
	"/art/spiral/spiral_indigo.png",
	"/art/spiral/spiral_cuzco2.png",
	"/art/spiral/spiral_dd_small.png",
	"/art/spiral/spiral_oxg_cuzco.png",
	"/art/matilde-alpha.png",
	"/art/18_Gobi256_8b_alpha.png",
	"/art/FLIPO_027_SC1425.png",
	"/art/theend.png",
	"/art/revision-2023-logo.png",
	"/art/env2.jpg",
	"/art/env.jpg",
	"/art/noise.png",

	"/art/FLIPO_000_SC1425.png",
	"/art/30_alpha.png",
	"/art/dd_intro.png",
	"/art/flipo-and-sm.png",
	"/art/flipo-present-sm.png",
	"/art/05_Flipman_8b.png",
	"/art/flipo-screen-text-2.png",
	"/art/F2.png",
	"/art/L2.png",
	"/art/I2.png",
	"/art/P2.png",
	"/art/O2.png",
	"/art/12_Patriiick64.png",
	"/art/flipo_dots.png",
	"/art/15_Flipo3.png",
	"/art/flipo_f0.png",
	"/art/flipo_f1.png",
	"/art/flipo_f2.png",
	"/art/03_oxg02.png",

	//"/CourierPrime-Regular.ttf",
	"/art/white.png",
	"/art/font.png",
	
	"/art/credits/oxbab_credits.png",
	"/art/credits/leonard_credits.png",
	"/art/credits/mon_credits.png",
	"/art/credits/spiral_credits.png",
	"/art/credits/niko_credits.png",
	"/art/credits/jess_ben_credits.png",
	"/art/credits/credits_intro.jpeg",
	"/art/credits/credits_saw.jpeg",
	"/art/credits/credits_gb.jpeg",
	"/art/credits/credits_wave_2.jpeg",
	"/art/credits/credits_dragonballs.jpeg",
	"/art/credits/credits_tunnel.jpeg",
	"/art/credits/credits_patrick.jpeg",
	"/art/credits/credits_circles.jpeg",
	"/art/credits/credits_credits.jpeg",
	"/art/credits/credits_spacecut.jpeg",
	"/art/credits/credits_3dlines.jpeg",
	"/art/credits/credits_spiral.jpeg",
	"/art/credits/credits_3ddots.jpeg",
	"/art/credits/credits_matilde.jpeg",
	"/art/credits/credits_spheres.jpeg",
	"/art/credits/credits_rotozoom.jpeg",
	"/art/credits/credits_end.jpeg",
	"/art/credits/credits_ovr.jpeg",
	"/art/credits/credits_end_spiral.jpeg",

	"/art/spacecut_text.png",
	"/art/matilde_text.png",
	"/art/10_Flippisme_8b.png",

	"art/sprite.png",
	"art/sprite_bg.png",
	"art/scroll_record.png",


]

/*self.addEventListener('activate', event => {
	event.waitUntil(async function() {
	if (self.registration.navigationPreload) {
		await self.registration.navigationPreload.enable();
	}
	}());
});*/

/*self.addEventListener('activate', function(event) {
	console.log("activate");
	event.waitUntil((async () => {
		if ('navigationPreload' in self.registration) {
			await self.registration.navigationPreload.enable();
		}
	})())
	self.clients.claim()
})*/

self.addEventListener('install', (event) => {
	event.waitUntil(
		caches.open(CACHE_NAME)
		.then(cache => cache.addAll(assets))
		.then(self.skipWaiting())
		.catch(e => console.error(e))
	);
})

self.addEventListener('activate', event => {
    const currentCaches = [CACHE_NAME];
	event.waitUntil(
		caches.keys().then(cacheNames => {
			return cacheNames.filter(cacheName => !currentCaches.includes(cacheName));
		}).then(cachesToDelete => {
			return Promise.all(cachesToDelete.map(cacheToDelete => {
				return caches.delete(cacheToDelete);
			}));
		}).then(() => self.clients.claim())
	);
});

self.addEventListener('fetch', event => {
	let { url } = event.request
	//console.log(event.request.url, event.request.mode)

	if(url.indexOf('/src/') !== -1) return
	if(url.indexOf('/node_modules/') !== -1) return
	if(url.indexOf('/@vite/') !== -1) return

	if (event.request.url.startsWith(self.location.origin)) {
		
		event.respondWith((async _ => { 
			const cachedResponse = await caches.match(event.request)
			if (cachedResponse) {
				//console.log(url, "CACHED")
				return cachedResponse;
			}
			//console.log(url, "not cached")
			return fetch(event.request) 
		})())

		// network first
		/*event.respondWith((async _ => { 
			let cache = await caches.open(CACHE_NAME)
			return fetch(event.request).then(response => {
				console.log(url, "network", response.statusText, response.arrayBuffer.length)
				cache.put(event.request, response.clone())
				return response
			}).catch(() => {
				console.log(url, "cache")
				return cache.match(event.request.url)
			})
		})())*/


	}
});
