

#include "Shader.h"
#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;                                 
layout(std430) buffer           ConstantBuffer { vec4 constantBuffer[]; };  
uniform shader                  PixelShader;                                
uniform uint                    Background;                                 
uniform uint                    ProjectionMode;                             
uniform vec3                    BackgroundColor;                            
uniform float                   BackgroundAspect;                           
uniform float                   BackgroundIntensity;                        
out vec4                        FragColor;                                  










vec2 SampleSphericalMap(in vec3 rayDirection)
{
    return vec2(
        atan(rayDirection.z, rayDirection.x) / (2.0f * FW_PI) + 0.5f,
        1.0f - acos(rayDirection.y) / FW_PI);
}

_kernel


void BackgroundPass()
{
    vec2 uv;
    switch(ProjectionMode)
    {
    case 0:     
        if(Background == uint(-1))
            uv = vTexcoords;
        else
        {
            const float aspect = (Aspect / BackgroundAspect);
            vec2 ndc = (2.0f * vTexcoords - 1.0f);
            if(aspect > 1.0f) ndc.y /= aspect;
                         else ndc.x *= aspect;
            uv = 0.5f * ndc + 0.5f; 
        }
        break;
    case 1:     
        {
            vec4 worldPosition = ViewProjectionInverse * vec4(2.0f * vTexcoords - 1.0f, 0.0f, 1.0f);
            worldPosition.xyz /= worldPosition.w;   
            uv = SampleSphericalMap(normalize(worldPosition.xyz - Eye));
        }
        break;
    default:    
        uv = vec2(0.5f);
        break;
    }
    vec4 dst = vec4(BackgroundColor, 1.0f);
    if(Background != uint(-1))
        switch(ProjectionMode)
        {
        case 0:     
            {
                const vec4 src = Sample(Background, uv);
                dst.xyz = mix(dst.xyz, src.xyz, src.w);
            }
            break;
        case 1:     
            {
                vec2 dPdx = dFdx(vTexcoords);
                vec2 dPdy = dFdy(vTexcoords);
                dPdx /= 1.5f * FW_PI;   
                dPdy /= 1.5f * FW_PI;
                const vec4 src = SampleGrad(Background, uv, dPdx, dPdy);
                dst.xyz = mix(dst.xyz, src.xyz, src.w);
            }
            break;
        default:    
            break;
        }
    PixelShader(vTexcoords, dst);
    dst.xyz = pow(dst.xyz, vec3(2.2f));
    FragColor = vec4(dst.xyz * BackgroundIntensity, 1.0f);
}
