

#ifndef BLEND_H
#define BLEND_H



#define BLEND_MODE_MULTIPLY     0



#define BLEND_MODE_SCREEN       1



#define BLEND_MODE_ADD          2



#define BLEND_MODE_SUBTRACT     3



#define BLEND_MODE_REPLACE      4



#define BLEND_MODE_MIN          5



#define BLEND_MODE_MAX          6



#define BLEND_MODE_DIFFERENCE   7



#define BLEND_MODE_NEGATION     8



#define BLEND_MODE_EXCLUSION    9



#define BLEND_MODE_OVERLAY      10



#define BLEND_MODE_HARD_LIGHT   11



#define BLEND_MODE_SOFT_LIGHT   12



#define BLEND_MODE_DODGE        13



#define BLEND_MODE_BURN         14



#define BLEND_CHANNEL_R         (1 << 0)



#define BLEND_CHANNEL_G         (1 << 1)



#define BLEND_CHANNEL_B         (1 << 2)



#define BLEND_CHANNEL_A         (1 << 3)













vec4 BlendColorValues(in vec4 dst, in vec4 src, in uint blendMode, in float blendAmount)
{
    switch(blendMode)
    {
    case BLEND_MODE_MULTIPLY:
        dst = mix(dst, dst * src, blendAmount);
        break;
    case BLEND_MODE_SCREEN:
        dst = mix(dst, 1.0f - (1.0f - dst) * (1.0f - src), blendAmount);
        break;
    case BLEND_MODE_ADD:
        dst = mix(dst, dst + src, blendAmount);
        break;
    case BLEND_MODE_SUBTRACT:
        dst = mix(dst, dst - src, blendAmount);
        break;
    case BLEND_MODE_REPLACE:
        dst = mix(dst, src, blendAmount);
        break;
    case BLEND_MODE_MIN:
        dst = mix(dst, min(dst, src), blendAmount);
        break;
    case BLEND_MODE_MAX:
        dst = mix(dst, max(dst, src), blendAmount);
        break;
    case BLEND_MODE_DIFFERENCE:
        dst = mix(dst, abs(dst - src), blendAmount);
        break;
    case BLEND_MODE_NEGATION:
        dst = mix(dst, 1.0f - abs(1.0f - dst - src), blendAmount);
        break;
    case BLEND_MODE_EXCLUSION:
        dst = mix(dst, dst + src - 2.0f * dst * src, blendAmount);
        break;
    case BLEND_MODE_OVERLAY:
        dst = mix(dst, mix(2.0f * dst * src, 1.0f - 2.0f * (1.0f - dst) * (1.0f - src), 1.0f - vec4(lessThan(dst, vec4(0.5f)))), blendAmount);
        break;
    case BLEND_MODE_HARD_LIGHT:
        dst = mix(dst, mix(2.0f * dst * src, 1.0f - 2.0f * (1.0f - dst) * (1.0f - src), 1.0f - vec4(lessThan(src, vec4(0.5f)))), blendAmount);
        break;
    case BLEND_MODE_SOFT_LIGHT:
        dst = mix(dst, mix(2.0f * dst * src + dst * dst * (1.0f - 2.0f * src), sqrt(dst) * (2.0f * src - 1.0f) + 2.0f * dst * (1.0f - src), 1.0f - vec4(lessThan(src, vec4(0.5f)))), blendAmount);
        break;
    case BLEND_MODE_DODGE:
        dst = mix(dst, dst / max(1.0f - src, 1e-3f), blendAmount);
        break;
    case BLEND_MODE_BURN:
        dst = mix(dst, 1.0f - (1.0f - dst) / max(src, 1e-3f), blendAmount);
        break;
    default:    
        break;
    }

    return dst;
}









vec4 BlendColorChannels(in vec4 dst, in vec4 src, in uint blendChannels)
{
    vec4 res;

    res.x = ((blendChannels & BLEND_CHANNEL_R) != 0 ? src.x : dst.x);
    res.y = ((blendChannels & BLEND_CHANNEL_G) != 0 ? src.y : dst.y);
    res.z = ((blendChannels & BLEND_CHANNEL_B) != 0 ? src.z : dst.z);
    res.w = ((blendChannels & BLEND_CHANNEL_A) != 0 ? src.w : dst.w);

    return res;
}










vec4 Blend(in vec4 dst, in vec4 src, in uint blendMode, in float blendAmount)
{
    return BlendColorValues(dst, src, blendMode, blendAmount);
}











vec4 Blend(in vec4 dst, in vec4 src, in uint blendMode, in float blendAmount, in uint blendChannels)
{
    return BlendColorChannels(dst, BlendColorValues(dst, src, blendMode, blendAmount), blendChannels);
}










vec4 Blend(in vec4 dst, in vec4 src, in float blendAmount, in uint blendChannels)
{
    return BlendColorChannels(dst, mix(dst, src, blendAmount), blendChannels);
}

#endif 
