

#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;     
uniform sampler2D               ColorBuffer;    
uniform sampler2D               LensDirtBuffer; 
uniform vec2                    BlurDirection;  
uniform float                   LensDirtBlend;  
uniform float                   LensDirtAspect; 
uniform float                   BlendWeight;    
uniform float                   Threshold;      
uniform float                   LumaClamp;      
uniform uint                    MipLevel;       
out vec4                        FragColor;      








vec3 SampleSceneColor(in vec2 uv, in float mipLevel)
{
    vec3 color = textureLod(ColorBuffer, uv, mipLevel).xyz;
    if(BlurDirection.x != 0.0f && MipLevel == 0)
    {
        color = max(color - Threshold, 0.0f);   
        color /= (1.0f + color);    
        color *= min(LumaClamp / color, 1.0f);
        color /= max(1.0f - color, 1e-3f);
    }
    return color;
}

_kernel


void BloomBlur()
{
    const uint kernelRadius = 16;
    const float kernel[kernelRadius] =
    {
        0.074693f, 0.073396f, 0.069638f, 0.063796f,
        0.056431f, 0.048197f, 0.039746f, 0.031648f,
        0.024332f, 0.018063f, 0.012947f, 0.008961f,
        0.005988f, 0.003864f, 0.002407f, 0.001448f
    };
    const float mipLevel = float(MipLevel == 0 ? 0 : MipLevel - 1);
    const vec2 blurDirection = BlurDirection * ViewportWidthHeightInverse;
    vec4 color = vec4(kernel[0] * SampleSceneColor(vTexcoords, mipLevel), 1.0f);
    for(uint i = 1; i < kernelRadius; ++i)
    {
        color.xyz += kernel[i] * SampleSceneColor(vTexcoords + i * blurDirection, mipLevel);
        color.xyz += kernel[i] * SampleSceneColor(vTexcoords - i * blurDirection, mipLevel);
    }
#ifdef DO_BLEND
    color *= vec4(vec3(BlendWeight), 0.0f);
#ifdef DO_LENS_DIRT
    vec2 ndc = 2.0f * vTexcoords - 1.0f;
    const float aspect = Aspect / LensDirtAspect;
    if(aspect > 1.0f) ndc.y /= aspect;
                 else ndc.x *= aspect;
    color.xyz *= mix(1.0f, texture(LensDirtBuffer, 0.5f * ndc + 0.5f).x, LensDirtBlend);
#endif 
#endif 
    FragColor = color;
}

_kernel


void BloomBlend()
{
    const float mipLevel = float(MipLevel - 1);
    vec3 color = textureLod(ColorBuffer, vTexcoords, mipLevel).xyz;
#ifdef DO_LENS_DIRT
    vec2 ndc = 2.0f * vTexcoords - 1.0f;
    const float aspect = Aspect / LensDirtAspect;
    if(aspect > 1.0f) ndc.y /= aspect;
                 else ndc.x *= aspect;
    color *= mix(1.0f, texture(LensDirtBuffer, 0.5f * ndc + 0.5f).x, LensDirtBlend);
#endif 
    FragColor = vec4(color * BlendWeight, 1.0f);    
}

_kernel


void BloomDownsample()
{
    vec3 result = vec3(0.0f);
    const float kernel[9] =
    {
        0.077847f, 0.123317f, 0.077847f,
        0.123317f, 0.195346f, 0.123317f,
        0.077847f, 0.123317f, 0.077847f
    };
    const vec2 scale = 2.0f * ViewportWidthHeightInverse;
    const float mipLevel = float(MipLevel == 0 ? 0 : MipLevel - 1);
    for(int y = -1, i = 0; y <= 1; ++y)
        for(int x = -1; x <= 1; ++x, ++i)
        {
            vec3 color = SampleSceneColor(vTexcoords + vec2(x, y) * scale, mipLevel);
            if(MipLevel == 0)
                color = log(max(color, 1e-6f));
            color *= kernel[i];
            result += color;
        }
    if(MipLevel == 0)
        result = exp(result);
    FragColor = vec4(result, 1.0f);
}
