

#include "ShaderCore.h"

layout(std430) buffer           RayHitBuffer { HitData rayHitBuffer[]; };   
noperspective sample in vec2    vTexcoords;                                 
out vec4                        FragColor;                                  

_kernel


void DrawBricks()
{
    FragColor = vec4(GetPassthruColor(vec3(1.0f, 0.0f, 0.0f)), 1.0f);
}

_kernel


void DrawVoxels()
{
    FragColor = vec4(GetPassthruColor(vec3(0.0f, 0.0f, 1.0f)), 1.0f);
}

_kernel


void DrawHeatmap()
{
    const uvec2 pixelCoordinates = uvec2(vTexcoords * ViewportWidthHeight);
    const uint pixelIndex = pixelCoordinates.x + pixelCoordinates.y * uint(ViewportWidthHeight.x);
    const uint stepCount = floatBitsToUint(rayHitBuffer[pixelIndex].m_data.x);  
    FragColor = vec4(GetPassthruColor(ViridisQuintic(5e-2f * stepCount)), 1.0f);
}
