

#ifndef BRICKMAP_H
#define BRICKMAP_H



struct Cell
{
    uvec3   m_boundsMin;        
    uint    m_begin;            
    uvec3   m_boundsMax;        
    uint    m_end;              
};



struct VoxelConfig
{
    uint    m_brickCount;       
    float   m_brickSize;        
    uint    m_brickTotalCount;  
    uint    m_triangleCount;    
    vec4    m_gridTransform;    
};








uint To1D(in uvec3 index, in uint count)
{
    return index.x + (index.y + index.z * count) * count;
}








uvec3 To3D(in uint index, in uint count)
{
    return uvec3(
        index % count,
        (index / count) % count,
        index / (count * count));
}







void DecodeBrick(in uint brick, out uint voxelResolution, out uint voxelOffset)
{
    voxelResolution = (brick >> 29);
    voxelOffset = (brick & 0x1FFFFFFFu);
}

#endif 
