

#ifndef BXDF_H
#define BXDF_H

#include "ShaderCore.h"










float DistributionGGX(in float nDotH, in float roughness)
{
    float a = roughness * roughness;
    float a2 = a * a;
    float nDotH2 = nDotH * nDotH;

    float denom = (nDotH2 * (a2 - 1.0f) + 1.0f);
    denom = FW_PI * denom * denom;

    return a2 / denom;
}










vec3 FresnelSchlick(in float nDotV, in vec3 fresnelBase)
{
    return fresnelBase + (1.0f - fresnelBase) * pow(1.0f - nDotV, 5.0f);
}












vec3 FresnelSchlickRoughness(in float nDotV, in vec3 fresnelBase, in float roughness)
{
    return fresnelBase + (max(vec3(1.0f - roughness), fresnelBase) - fresnelBase) * pow(1.0f - nDotV, 5.0f);
}










float GeometrySchlickGGX(in float nDotV, in float roughness)
{
    float r = (roughness + 1.0f);
    float k = (r * r) / 8.0f;

    float denom = nDotV * (1.0f - k) + k;

    return nDotV / denom;
}










float GeometrySchlickGGXIBL(in float nDotV, in float roughness)
{
    float a = roughness * roughness;
    float k = a / 2.0f;

    float denom = nDotV * (1.0f - k) + k;

    return nDotV / denom;
}











float GeometrySmith(in float nDotV, in float nDotL, in float roughness)
{
    float ggx2 = GeometrySchlickGGX(nDotV, roughness);
    float ggx1 = GeometrySchlickGGX(nDotL, roughness);

    return ggx1 * ggx2;
}











float GeometrySmithIBL(in float nDotV, in float nDotL, in float roughness)
{
    float ggx2 = GeometrySchlickGGXIBL(nDotV, roughness);
    float ggx1 = GeometrySchlickGGXIBL(nDotL, roughness);

    return ggx1 * ggx2;
}











float SpecularOcclusion(in float nDotV, in float ao)
{
    const float so = ao + (ao + nDotV) * (ao + nDotV) - 1.0f;
    return clamp(so, 0.0f, 1.0f);
}

#endif 
