

#include "Blend.h"
#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;     
uniform sampler2D               ColorBuffer;    
uniform float                   Strength;       
uniform float                   Falloff;        
uniform float                   BlendAmount;    
uniform uint                    BlendChannels;  
out vec4                        FragColor;      







vec3 SimpleTonemap(in vec3 color)
{
    return color / (1.0f + color);
}







vec3 SimpleTonemapInverse(in vec3 color)
{
    return color / max(1.0f - color, 1e-3f);
}







vec2 Remap(in vec2 uv)
{
    vec2 ndc = 2.0f * uv - 1.0f;
    ndc = sign(ndc) * pow(abs(ndc), vec2(max(Falloff, 1.0f)));
    return max(Strength, 0.0f) * ndc / 100.0f;
}











vec3 Chromatic(in vec2 uv, in vec2 amount)
{
    vec3 color = vec3(0.0f);
    vec3 weight = vec3(0.0f);
    const float delta = 0.04f;
    const float spec = 2.0f * FW_PI / 3.0f;
    for(float i = -1.0f; i <= 1.0f; i += delta)
    {
        const vec3 mask = 0.5f * cos(FW_PI * i + vec3(-spec, 0.0f, spec)) + 0.5f;
        color += mask * SimpleTonemap(textureLod(ColorBuffer, uv - amount * i, 0.0f).xyz);
        weight += mask; 
    }
    return SimpleTonemapInverse(color / weight);
}

_kernel


void ChromaticDispersion()
{
    const vec3 dst = textureLod(ColorBuffer, vTexcoords, 0.0f).xyz,
               src = Chromatic(vTexcoords, Remap(vTexcoords));
    FragColor = Blend(vec4(dst, 1.0f), vec4(src, 1.0f), BlendAmount, BlendChannels);
}
