

#include "Blend.h"
#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;     
uniform sampler2D               ColorBuffer;    
uniform vec4                    TintExposure;   
uniform float                   Saturation;     
uniform float                   Contrast;       
uniform vec4                    Lift;           
uniform vec4                    Gamma;          
uniform vec4                    Gain;           
uniform vec3                    Vignette;       
uniform float                   BlendAmount;    
uniform uint                    BlendChannels;  
out vec4                        FragColor;      







vec3 ApplyVignette(in vec3 color)
{
    const vec2 uv = vTexcoords * (1.0f - vTexcoords.yx);
    float vignetting = uv.x * uv.y * Vignette.y;
    vignetting = pow(vignetting, Vignette.z);
    return mix(color, color * vignetting, Vignette.x);
}










vec3 EvalLogContrastFunc(in vec3 color, in float epsilon, in float logMidpoint, in float contrast)
{
    const vec3 logColor = log2(color + epsilon);
    const vec3 adjColor = logMidpoint + (logColor - logMidpoint) * contrast;
    return max(exp2(adjColor) - epsilon, 0.0f);
}










vec3 EvalLiftGammaGainFunc(in vec3 color, in vec3 lift, in vec3 gamma, in vec3 gain)
{
    const vec3 lerpColor = clamp(pow(color, 1.0f / gamma), 0.0f, 1.0f);
    return mix(lift, gain, lerpColor);
}

_kernel





void ColorGrading()
{
    const vec3 dst = textureLod(ColorBuffer, vTexcoords, 0.0f).xyz;
    vec3 src = dst * exp2(TintExposure.w) * TintExposure.xyz;   
    src /= (1.0f + src);    
    const float greyscale = dot(src, vec3(0.25f, 0.5f, 0.25f));
    src = mix(vec3(greyscale), src, Saturation);    
    src = EvalLogContrastFunc(src, 1e-5f, 0.18f, Contrast);
    const float avgLift  = dot(Lift.xyz,  vec3(1.0f / 3.0f)),
                avgGamma = dot(Gamma.xyz, vec3(1.0f / 3.0f)),
                avgGain  = dot(Gain.xyz,  vec3(1.0f / 3.0f));
    const vec3 liftColor  = Lift.xyz  - avgLift,
               gammaColor = Gamma.xyz - avgGamma,
               gainColor  = Gain.xyz  - avgGain;
    vec3 lift  = 0.0f + (liftColor  + Lift.w),
         gamma = 0.5f + (gammaColor + Gamma.w),
         gain  = 1.0f + (gainColor  + Gain.w);
    gamma = log((0.5f - lift) / (gain - lift)) / log(gamma);
    src = EvalLiftGammaGainFunc(src, lift, gamma, gain);
    src = ApplyVignette(src);   
    src /= max(1.0f - src, 1e-3f);  
    FragColor = Blend(vec4(dst, 1.0f), vec4(src, 1.0f), BlendAmount, BlendChannels);
}
