

#include "Shader.h"
#include "Lighting.h"

layout(location = 0) out vec4   ColorOut;                                                   
layout(location = 1) out vec4   SpecularOut;                                                
layout(location = 2) out vec4   DetailsOut;                                                 
in vec3                         vNormal;                                                    
flat in uint                    vMaterialId;                                                
in vec2                         vTexcoords;                                                 
in vec3                         vObjectPosition;                                            
in vec3                         vWorldPosition;                                             
layout(std430) buffer           ConstantBuffer        { vec4 constantBuffer[];        };    
layout(std430) buffer           TerrainConstantBuffer { vec4 terrainConstantBuffer[]; };    
uniform shader                  MaterialShader;                                             
uniform shader                  TerrainShader;                                              
out vec4                        FragColor;                                                  
vec3                            Normal;                                                     





void MaterialApplyShader(inout Material material)
{
    Surface surface;
    surface.m_texcoords = vTexcoords;
    surface.m_normal = normalize(Normal);
    surface.m_objectPosition = vObjectPosition;
    surface.m_worldPosition = vWorldPosition;
    MaterialShader(surface, material);
}







vec3 TerrainEvaluateNormal(in vec2 uv)
{
    
    const float eps = 1e-5f * GetLinearDepth(gl_FragCoord.z),
                T = TerrainShader(uv + vec2(0.0f, -eps)),
                L = TerrainShader(uv + vec2(-eps, 0.0f)),
                R = TerrainShader(uv + vec2( eps, 0.0f)),
                B = TerrainShader(uv + vec2(0.0f,  eps));
    return vec3((L - R) / (2.0f * eps), 2e2f, (T - B) / (2.0f * eps));
}

_kernel


void DrawDefault()
{
    vec4 specularTerm;

    
#ifndef USE_TERRAIN_SHADER
    Normal = vNormal;
#else 
    Normal = TerrainEvaluateNormal(vTexcoords);
#endif 
    Material material = GetMaterial(vMaterialId, vTexcoords);
    const vec2 uv = gl_FragCoord.xy * ViewportWidthHeightInverse;
    const vec3 viewDirection = normalize(Eye - vWorldPosition), 
               normal = EvaluateNormal(material, Normal, vTexcoords, viewDirection);

    
    vec3 lighting = material.m_emissivity;

    for(LightIterator lightIt = LightBegin(); !LightEnd(lightIt); LightNext(lightIt))
    {
        LightData light = LightGet(lightIt);
        lighting += EvaluateDirectIllumination(light, material, normal, viewDirection, vWorldPosition);
    }
    lighting += EvaluateIndirectIllumination(uv, material, normal, viewDirection, specularTerm);

    
    ColorOut = vec4(RemoveNaNs(lighting), 1.0f);
    SpecularOut = specularTerm; 
    DetailsOut = vec4(0.5f * normal + 0.5f, 1.0f);
}
