

#include "ShaderCore.h"

layout(std430) buffer   MeshDataBuffer { MeshData meshDataBuffer[]; };  
out vec3                vNormal;                                        
flat out uint           vMaterialId;                                    
out vec2                vTexcoords;                                     
out vec3                vObjectPosition;                                
out vec3                vWorldPosition;                                 

_kernel


void DrawDefault()
{
    
    MeshData meshData = meshDataBuffer[iDrawId];
    mat4 matrix = GetTransform(meshData);
    vec4 worldPosition = matrix * vec4(Position, 1.0f);

    
    gl_Position = ViewProjection * worldPosition;
    vNormal = GetTransformedNormal(matrix, Normal);
    vMaterialId = GetMaterialId(meshData);
    vTexcoords = Texcoords;
    vObjectPosition = Position.xyz;
    vWorldPosition = worldPosition.xyz;
}
