

#include "ShaderCore.h"

uniform sampler2DArray  ColorBuffer;    
uniform sampler2DArray  NormalBuffer;   
out vec4                FragColor;      

_kernel


void ReinterleaveBuffers()
{
    const ivec2 coordsHi = ivec2(gl_FragCoord.xy);
    const ivec2 coordsLo = (coordsHi >> 2);
    const ivec2 slice = coordsHi - (coordsLo << 2);
    const int sliceIndex = slice.x + (slice.y << 2);
    FragColor = texelFetch(ColorBuffer, ivec3(coordsLo, sliceIndex), 0);
}

_kernel


void DebugDeinterleavedBuffers()
{
    const ivec2 dims = textureSize(NormalBuffer, 0).xy;
    const ivec2 coords = ivec2(gl_FragCoord.xy) % dims;
    const ivec2 slice = ivec2(gl_FragCoord.xy) / dims;
    const int sliceIndex = slice.x + (slice.y << 2);
    FragColor = texelFetch(NormalBuffer, ivec3(coords, sliceIndex), 0);
}
