

#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;         
uniform sampler2D               InputBuffer;        
uniform sampler2D               DepthBuffer;        
uniform sampler2D               NormalBuffer;       
uniform vec4                    BufferDimensions;   
uniform int                     StepSize;           
out vec4                        FragColor;          








float GetColorSimilarity(in float x1, in float x2, in float sigma)
{
    return exp(-abs(x1 - x2) / sigma);
}








float GetDepthSimilarity(in float x1, in float x2, in float sigma)
{
    return exp(-abs(x1 - x2) / sigma);
}








float GetNormalSimilarity(in vec3 x1, in vec3 x2)
{
    return pow(clamp(dot(x1, x2), 0.0f, 1.0f), 32.0f);
}







float FetchFilteredVariance(in ivec2 pos)
{
    const int k = 1;
    float variance = 0.0f;
    const float kernel[2][2] =
    {
        { 1.0f / 4.0f, 1.0f / 8.0f  },
        { 1.0f / 8.0f, 1.0f / 16.0f }
    };
    for(int y = -k; y <= k; ++y)
        for(int x = -k; x <= k; ++x)
        {
            const float w = kernel[abs(x)][abs(y)];
            const ivec2 p = clamp(pos + ivec2(x, y), ivec2(0), ivec2(BufferDimensions) - 1);
            variance += w * texelFetch(InputBuffer, p, 0).w;
        }
    return variance;
}

_kernel


void DebugTarget()
{
    FragColor = textureLod(InputBuffer, vTexcoords, 0.0f);
}

_kernel


void DebugVariance()
{
    const vec3 moments = textureLod(InputBuffer, vTexcoords, 0.0f).xyz;
    const float variance = (moments.z > 1.0f ? moments.y / (moments.z - 1.0f) : 1.0f);
    FragColor = vec4(sqrt(variance));   
}

_kernel


void EAWFilter()
{
    
    const ivec2 pos = ivec2(gl_FragCoord.xy);
    const vec4 colorCenter = texelFetch(InputBuffer, pos, 0);
    const float luminanceCenter = GetLuminance(colorCenter.xyz);
    const float variance = FetchFilteredVariance(pos);  
    const float stdDeviation = sqrt(max(variance + 1e-9f, 0.0f));

    
    const float depth = texelFetch(DepthBuffer, pos, 0).x;
    const float depthCenter = GetLinearDepth(depth);    
    const vec3 normalCenter = normalize(2.0f * texelFetch(NormalBuffer, pos, 0).xyz - 1.0f);

    
    vec4 colorSum = colorCenter;
    float weightSum = 1.0f;

    if(depth < 1.0f)
    {
        
        const int k = 1;
        const float kernel[3] = { 1.0f, 2.0f / 3.0f, 1.0f / 6.0f };

        for(int y = -k; y <= k; ++y)
            for(int x = -k; x <= k; ++x)
            {
                
                const ivec2 p = clamp(pos + ivec2(x, y) * StepSize, ivec2(0), ivec2(BufferDimensions) - 1);
                const float depthNeigh = texelFetch(DepthBuffer, p, 0).x;
                if((x == 0 && y == 0) || depthNeigh >= 1.0f)
                    continue;   

                
                const vec4 colorNeigh = texelFetch(InputBuffer, p, 0);
                const float luminanceNeigh = GetLuminance(colorNeigh.xyz);
                const vec3 normalNeigh = normalize(2.0f * texelFetch(NormalBuffer, p, 0).xyz - 1.0f);

                
                float w = kernel[abs(x)] * kernel[abs(y)];  
                w *= GetColorSimilarity(luminanceCenter, luminanceNeigh, stdDeviation);
                w *= GetDepthSimilarity(depthCenter, GetLinearDepth(depthNeigh), 1.0f);
                w *= GetNormalSimilarity(normalCenter, normalNeigh);

                
                colorSum += vec4(w.xxx, w * w) * colorNeigh;
                weightSum += w;
            }
    }

    
    FragColor = vec4(colorSum.xyz / weightSum,
                     colorSum.w / (weightSum * weightSum));
}
