

#include "ShaderCore.h"

flat                 out vec3   vColor;         
noperspective sample out vec2   vTexcoords;     
flat                 out vec3   vWorldPosition; 

_kernel


void Debug()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}

_kernel


void DrawGrid()
{
    float eyeHeight = Eye.y;
    vec3 projectedEye = vec3(Eye.x, -1e-3f, Eye.z);
    vec3 worldPosition = projectedEye + eyeHeight * vec3(View[0][2], View[1][2], View[2][2]);

    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
    vWorldPosition = worldPosition;
}

_kernel


void DrawLines()
{
    vec3 position = vec3(0.0f);
    switch(gl_InstanceID)
    {
    case 0:
        position = vec3(Position.x, -1.0f / 3.0f, 0.0f);
        break;
    case 1:
        position = vec3(Position.x,  1.0f / 3.0f, 0.0f);
        break;
    case 2:
        position = vec3(-1.0f / 3.0f, Position.x, 0.0f);
        break;
    case 3:
        position = vec3( 1.0f / 3.0f, Position.x, 0.0f);
        break;
    }
    gl_Position = vec4(position, 1.0f);
}

_kernel


void DrawGizmo()
{
    uint d = 1;
    vec3 position = vec3(0.0f);
    const vec3 forward = GetForward();
    uint x = (forward.x > forward.z ? 0 : 1);
    if(forward.y > 0.0f)
    {
        d += 2;
        ++x;
    }
    if(gl_InstanceID == x)
    {
        vColor = pow(vec3(0.96f, 0.21f, 0.32f), vec3(2.5f));    
        position -= max(Position.x, 0.0f) * vec3(1.0f, 0.0f, 0.0f);
    }
    else if(gl_InstanceID == d - x)
    {
        vColor = pow(vec3(0.18f, 0.52f, 0.89f), vec3(2.5f));    
        position -= max(Position.x, 0.0f) * vec3(0.0f, 0.0f, 1.0f);
    }
    else
    {
        vColor = pow(vec3(0.44f, 0.64f, 0.11f), vec3(1.5f));    
        position -= max(Position.x, 0.0f) * vec3(0.0f, 1.0f, 0.0f);
    }
    position = (View * vec4(position, 0.0f)).xyz;
    float gizmoSize = 30.0f;    
    gizmoSize = 2.0f * gizmoSize / min(ViewportWidthHeight.x / Aspect, ViewportWidthHeight.y);
    gizmoSize = min(gizmoSize, 0.8f * min(Aspect, 1.0f));   
    position.xy = 1.0f - gizmoSize * (1.25f + position.xy) / vec2(Aspect, 1.0f);
    gl_Position = vec4(position.xy, 0.0f, 1.0f);
}
