

#include "Hash.h"
#include "Blend.h"
#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;     
uniform sampler2D               InputBuffer;    
uniform float                   BlendAmount;    
uniform uint                    BlendChannels;  
uniform vec4                    Params;         
out vec4                        FragColor;      







vec3 ToLDR(in vec3 hdr)
{
    return hdr / (1.0f + hdr);
}


float Gaussian(in float z, in float u, in float o)
{
    return (1.0f / (o * sqrt(2.0f * FW_PI))) * exp(-(((z - u) * (z - u)) / (2.0f * (o * o))));
}

_kernel


void FilmGrading()
{
    const uvec2 pos = uvec2(gl_FragCoord.xy);
    const float t = (Frame / 60.0f) * Params.x;
    const float seed = float(pcg(pos.x + pcg(pos.y)) >> 16);
    const float noise1 = Gaussian(fract(sin(seed) * 43758.5453f + t), Params.z, Params.w * Params.w);
    const float noise2 = Gaussian(fract(sin(seed) * 76758.5453f + t), Params.z, Params.w * Params.w);
    const float noise3 = Gaussian(fract(sin(seed) * 99788.5453f + t), Params.z, Params.w * Params.w);
    const vec3 dst = textureLod(InputBuffer, vTexcoords, 0.0f).xyz; 
    const vec3 src = max((2.0f * vec3(noise1, noise2, noise3) - 1.0f) *  Params.y + dst, 0.0f);
    FragColor = Blend(vec4(dst, 1.0f), vec4(src, 1.0f), BlendAmount, BlendChannels);
}
