

#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;     
uniform sampler2D               DepthBuffer;    
uniform vec4                    FogColor;       
uniform vec4                    FogParams;      
uniform vec3                    SunColor;       
uniform vec4                    SunParams;      
out vec4                        FragColor;      





float UniformPhase()
{
    return 1.0f / (4.0f * FW_PI);
}











float HgPhase(in float g, in float cosTheta)
{
    const float numer = 1.0f - g * g;
    const float denom = 1.0f + g * g + 2.0f * g * cosTheta;
    return numer / (4.0f * FW_PI * denom * sqrt(denom));
}

_kernel





void DrawFog()
{
    const float depth = textureLod(DepthBuffer, vTexcoords, 0.0f).x;
    if(FogColor.w != 0.0f && depth >= 1.0f)
        discard;    
    const vec3 world = GetWorldPosition(GetScreenPosition(vTexcoords), depth);
    float fogAmount = SunParams.w;
    if(depth < 1.0f)
    {
        const float distance = GetLinearDepth(depth);   
        const float startDistanceFalloff = clamp((distance - FogParams.y) / FogParams.y, 0.0f, 1.0f);
        const float fogFalloffScale = 1.0f / max(FogParams.w - FogParams.z, 1e-2f);
        const float fogFalloff = 6.907755f * fogFalloffScale;   
        const float Z = normalize(world - vec3(Eye.x, 0.0f, Eye.z)).y;
        const float effectiveZ = max(abs(Z), 1e-3f);
        const float endLineHeight = distance * Z;   
        const float minLineHeight = min(endLineHeight, 0.0f);
        const float heightLineFalloff = max(minLineHeight - FogParams.z, 0.0f);
        const float baseHeightFogDistance = clamp((FogParams.z - minLineHeight) / effectiveZ, 0.0f, distance);
        const float exponentialFogDistance = distance - baseHeightFogDistance;  
        const float exponentialHeightLineIntegral = exp(-heightLineFalloff * fogFalloff) * (1.0f - exp(-exponentialFogDistance * effectiveZ * fogFalloff)) / (effectiveZ * fogFalloff);
        const float opticalDepthHeightFog = FogParams.x * startDistanceFalloff * (baseHeightFogDistance + exponentialHeightLineIntegral);
        const float transmittanceHeightFog = exp(-opticalDepthHeightFog);
        fogAmount *= 1.0f - transmittanceHeightFog;
    }
    const vec3 L = SunParams.xyz;
    const vec3 V = normalize(Eye - world);
    vec3 sunColor = SunColor;
    sunColor *= UniformPhase();
    sunColor *= HgPhase(0.6f, dot(V, L));
    FragColor = vec4(FogColor.xyz + sunColor, fogAmount);
}
