

#include "ShaderCore.h"

layout(triangles)                            in;                                    
layout(triangle_strip, max_vertices = 3)     out;                                   
layout(std430) buffer   TriangleBuffer       { Triangle triangleBuffer[];       };  
layout(std430) buffer   TriangleDataBuffer   { uvec3    triangleDataBuffer[];   };  
layout(std430) buffer   TriangleCountBuffer  { uint     triangleCountBuffer[];  };  
layout(std430) buffer   ReferenceCountBuffer { uint     referenceCountBuffer[]; };  
uniform vec3            GridScale;                                                  
uniform vec3            GridBias;                                                   
uniform ivec3           GridDimensions;                                             
uniform uint            MaxTriangleCount;                                           







vec3 GridTransform(in vec3 p)
{
    return GridScale * (p + GridBias);
}







uint PackBounds(in ivec3 bounds)
{
    return ((bounds.x & 0x3FF) << 20) |
           ((bounds.y & 0x3FF) << 10) |
           ((bounds.z & 0x3FF) << 0);
}

_kernel


void CaptureTriangles()
{
    Triangle triangle;

    
    triangle.m_v0 = vec4(GridTransform(gl_in[0].gl_Position.xyz), 0.0f);
    triangle.m_v1 = vec4(GridTransform(gl_in[1].gl_Position.xyz), 0.0f);
    triangle.m_v2 = vec4(GridTransform(gl_in[2].gl_Position.xyz), 0.0f);

    
    ivec3 minBounds = ivec3(min(triangle.m_v0.xyz, min(triangle.m_v1.xyz, triangle.m_v2.xyz)) * GridDimensions);
    ivec3 maxBounds = ivec3(max(triangle.m_v0.xyz, max(triangle.m_v1.xyz, triangle.m_v2.xyz)) * GridDimensions);
    if(any(greaterThanEqual(minBounds, GridDimensions)) || any(lessThan(maxBounds, ivec3(0))))
        return; 

    
    const ivec3 tileDimensions = ((GridDimensions + 3) >> 2);
    minBounds = min((max(minBounds, ivec3(0)) >> 2), tileDimensions - 1);
    maxBounds = min((max(maxBounds, ivec3(0)) >> 2), tileDimensions - 1);
    const uint tileCount = (maxBounds.x - minBounds.x + 1) * (maxBounds.y - minBounds.y + 1) * (maxBounds.z - minBounds.z + 1);

    
    const uint triangleIndex = atomicAdd(triangleCountBuffer[0], 1);
    if(triangleIndex >= MaxTriangleCount)
        return; 
    const uint scatterIndex = atomicAdd(referenceCountBuffer[0], tileCount);

    
    triangleBuffer[triangleIndex] = triangle;
    triangleDataBuffer[triangleIndex] = uvec3(PackBounds(minBounds), PackBounds(maxBounds), scatterIndex);
}
