

#include "ShaderCore.h"

layout(std430) buffer           MeshDataBuffer { MeshData meshDataBuffer[]; };  
noperspective sample out vec2   vTexcoords;                                     

_kernel


void CaptureTriangles()
{
    MeshData meshData = meshDataBuffer[iDrawId];
    const mat4 matrix = GetTransform(meshData);
    gl_Position = matrix * vec4(Position, 1.0f);
}
