

#include "ShaderCore.h"

layout(lines)                           in;                         
layout(line_strip, max_vertices = 24)   out;                        
uniform mat4                            DebugViewProjectionInverse; 

_kernel


void DrawViewFrustum()
{
    
    vec4 frustumCorners[8] =
    {
        
        vec4(-1.0f, -1.0f, -1.0f, 1.0f),
        vec4(-1.0f,  1.0f, -1.0f, 1.0f),
        vec4( 1.0f,  1.0f, -1.0f, 1.0f),
        vec4( 1.0f, -1.0f, -1.0f, 1.0f),

        
        vec4(-1.0f, -1.0f, 0.95f, 1.0f),
        vec4(-1.0f,  1.0f, 0.95f, 1.0f),
        vec4( 1.0f,  1.0f, 0.95f, 1.0f),
        vec4( 1.0f, -1.0f, 0.95f, 1.0f)
    };

    
    for(uint i = 0; i < 8; ++i)
    {
        frustumCorners[i] = DebugViewProjectionInverse * frustumCorners[i];
        frustumCorners[i] /= frustumCorners[i].w;   
        frustumCorners[i] = ViewProjection * frustumCorners[i];
    }

    
    gl_Position = frustumCorners[0];
    EmitVertex();
    gl_Position = frustumCorners[1];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[1];
    EmitVertex();
    gl_Position = frustumCorners[2];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[2];
    EmitVertex();
    gl_Position = frustumCorners[3];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[3];
    EmitVertex();
    gl_Position = frustumCorners[0];
    EmitVertex();
    EndPrimitive();

    
    gl_Position = frustumCorners[4];
    EmitVertex();
    gl_Position = frustumCorners[5];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[5];
    EmitVertex();
    gl_Position = frustumCorners[6];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[6];
    EmitVertex();
    gl_Position = frustumCorners[7];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[7];
    EmitVertex();
    gl_Position = frustumCorners[4];
    EmitVertex();
    EndPrimitive();

    
    gl_Position = frustumCorners[0];
    EmitVertex();
    gl_Position = frustumCorners[4];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[1];
    EmitVertex();
    gl_Position = frustumCorners[5];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[2];
    EmitVertex();
    gl_Position = frustumCorners[6];
    EmitVertex();
    EndPrimitive();

    gl_Position = frustumCorners[3];
    EmitVertex();
    gl_Position = frustumCorners[7];
    EmitVertex();
    EndPrimitive();
}
