

#include "ShaderCore.h"

layout(std430) buffer   MeshDataBuffer         { MeshData meshDataBuffer[];         };  
layout(std430) buffer   PreviousMeshDataBuffer { MeshData previousMeshDataBuffer[]; };  
out vec3                vNormal;                                                        
flat out vec3           vMeshData;                                                      
out vec2                vTexcoords;                                                     
out vec3                vObjectPosition;                                                 
out vec3                vWorldPosition;                                                 
out vec4                vCurrentPosition;                                               
out vec4                vPreviousPosition;                                              

_kernel


void DrawDepth()
{
    
    MeshData meshData = meshDataBuffer[iDrawId];
    mat4 matrix = GetTransform(meshData);
    vec4 worldPosition = matrix * vec4(Position, 1.0f);
    vMeshData = meshData.m_meshData.yzw;    

    
    gl_Position = ViewProjection * worldPosition;
    vNormal = GetTransformedNormal(matrix, Normal);
    vWorldPosition = worldPosition.xyz;
    vObjectPosition = Position;
    vTexcoords = Texcoords;
}

_kernel


void DrawDepthNormal()
{
    
    MeshData meshData = meshDataBuffer[iDrawId];
    mat4 matrix = GetTransform(meshData);
    vec4 worldPosition = matrix * vec4(Position, 1.0f);
    vMeshData = meshData.m_meshData.yzw;    

    
    gl_Position = ViewProjection * worldPosition;
    vNormal = GetTransformedNormal(matrix, Normal);
    vWorldPosition = worldPosition.xyz;
    vObjectPosition = Position;
    vTexcoords = Texcoords;
}

_kernel


void DrawDepthNormalVelocity()
{
    
    MeshData meshData = meshDataBuffer[iDrawId];
    mat4 matrix = GetTransform(meshData);
    vec4 worldPosition = matrix * vec4(Position, 1.0f);
    vMeshData = meshData.m_meshData.yzw;    

    
    meshData = previousMeshDataBuffer[iDrawId];
    mat4 previousMatrix = GetTransform(meshData);
    vec4 previousWorldPosition = previousMatrix * vec4(Position, 1.0f);

    
    gl_Position = ViewProjection * worldPosition;
    vNormal = GetTransformedNormal(matrix, Normal);
    vWorldPosition = worldPosition.xyz;
    vObjectPosition = Position;
    vTexcoords = Texcoords;

    
    vCurrentPosition = gl_Position;
    vPreviousPosition = PreviousViewProjection * previousWorldPosition;
}

_kernel


void DrawHistory()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}

_kernel


void DrawReflections()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}

_kernel


void DrawBrdf()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}

_kernel


void DrawEnvironment()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = vec2(Texcoords.x, 1.0f - Texcoords.y);
}

_kernel


void DrawIrradiance()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = vec2(Texcoords.x, 1.0f - Texcoords.y);
}

_kernel


void DrawGBuffers()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}

_kernel


void DrawLightCount()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}

_kernel


void DrawDepthBounds()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}

_kernel


void DrawViewFrustum()
{
    gl_Position = vec4(Position, 1.0f);
}

_kernel


void DrawShadowBuffer()
{
    gl_Position = vec4(Position, 1.0f);
    vTexcoords = Texcoords;
}
