

#include "Blend.h"
#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;         
uniform sampler2D               InputBuffer;        
uniform float                   Time;               
uniform float                   RGBIntensity;       
uniform float                   DisplaceIntensity;  
uniform float                   InterlaceIntensity; 
uniform float                   DropoutIntensity;   
uniform float                   BlendAmount;        
uniform uint                    BlendChannels;      
out vec4                        FragColor;          

float rand(in float n)
{
    return fract(sin(n) * 43758.5453123f);
}

float noise(in float p)
{
    float fl = floor(p);
    float fc = fract(p);
    return mix(rand(fl), rand(fl + 1.0f), fc);
}

float hash(in vec2 p)
{
    p = 50.0f * fract(p * 0.3183099f + vec2(0.71f, 0.113f));
    return -1.0f + 2.0f * fract(p.x * p.y * (p.x + p.y));
}

float valueNoise(in vec2 p)
{
    vec2 i = floor(p);
    vec2 f = fract(p);

    vec2 u = f * f * (3.0f - 2.0f * f);

    return mix(mix(hash(i + vec2(0.0f, 0.0f)),
                   hash(i + vec2(1.0f, 0.0f)), u.x),
               mix(hash(i + vec2(0.0f, 1.0f)),
                   hash(i + vec2(1.0f, 1.0f)), u.x), u.y);
}

float blockyNoise(in vec2 uv, in float threshold, in float scale, in float seed)
{
    float scroll = floor(Time + sin(11.0f *  Time) + sin(Time)) * 0.77f;
    vec2 noiseUV = uv.yy / scale + scroll;
    float noise2 = valueNoise(0.125f * noiseUV * ViewportWidthHeight);

    float id = floor(noise2 * 20.0f);
    id = noise(id + seed) - 0.5f;

    if(abs(id) > threshold)
        id = 0.0f;

    return id;
}

_kernel

void Glitch()
{
    vec2 uv = vTexcoords;
    float rgbIntensity = (RGBIntensity > 0.0f ? (0.1f + 0.1f * sin(Time * 3.7f)) * RGBIntensity : 0.0f);
    float displaceIntensity = (DisplaceIntensity > 0.0f ? (0.2f + 0.3f * pow(sin(Time * 1.2f), 5.0f)) * DisplaceIntensity : 0.0f);
    float interlaceIntensity = (InterlaceIntensity > 0.0f ? 0.01f * InterlaceIntensity : 0.0f);
    float dropoutIntensity = (DropoutIntensity > 0.0f ? 0.1f * DropoutIntensity : 0.0f);
    float displace = blockyNoise(uv + vec2(uv.y, 0.0f), displaceIntensity, 25.0f, 66.6f);
    displace *= blockyNoise(uv.yx + vec2(0.0f, uv.x), displaceIntensity, 111.0f, 13.7f);
    uv.x += displace;   
    vec2 offs = 0.1f * vec2(blockyNoise(uv.xy + vec2(uv.y, 0.0f), rgbIntensity, 65.0f, 341.0f), 0.0f);
    float colr = textureLod(InputBuffer, uv - offs, 0.0f).r;
    float colg = textureLod(InputBuffer, uv       , 0.0f).g;
    float colb = textureLod(InputBuffer, uv + offs, 0.0f).b;
    float line = fract(gl_FragCoord.y / 3.0f);
    vec3 mask = vec3(3.0f, 0.0f, 0.0f);
    if(line > 0.333f)
        mask = vec3(0.0f, 3.0f, 0.0f);
    if(line > 0.666f)
        mask = vec3(0.0f, 0.0f, 3.0f);
    float maskNoise = blockyNoise(uv, interlaceIntensity, 90.0f, Time) * max(displace, offs.x);
    maskNoise = 1.0f - maskNoise;
    if(maskNoise == 1.0f)
        mask = vec3(1.0f);
    float dropout = blockyNoise(uv, dropoutIntensity, 11.0f, Time) * blockyNoise(uv.yx, dropoutIntensity, 90.0f, Time);
    mask *= (1.0f - 5.0f * dropout);
    vec3 dst = textureLod(InputBuffer, uv, 0.0f).xyz;
    vec3 src = mask * vec3(colr, colg, colb);
    FragColor = Blend(vec4(dst, 1.0f), vec4(src, 1.0f), BlendAmount, BlendChannels);
}
