

#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;     
uniform uint                    HDRIBuffer;     
out vec4                        FragColor;      










vec2 SampleSphericalMap(in vec3 rayDirection)
{
    return vec2(
        atan(rayDirection.z, rayDirection.x) / (2.0f * FW_PI) + 0.5f,
        1.0f - acos(rayDirection.y) / FW_PI);
}

_kernel


void DrawSky()
{
    const vec2 ndc = 2.0f * vTexcoords - 1.0f;
    vec4 worldPosition = ViewProjectionInverse * vec4(ndc, 0.0f, 1.0f);
    worldPosition.xyz /= worldPosition.w;   
#ifndef DRAW_SKYBOX
    const vec2 uv = SampleSphericalMap(normalize(worldPosition.xyz - Eye));
    const vec3 hdrValue = (HDRIBuffer != uint(-1) ? Sample(HDRIBuffer, uv).xyz : vec3(0.0f));
#else 
    const vec3 uv = normalize(worldPosition.xyz - Eye);
    const vec3 hdrValue = (HDRIBuffer != uint(-1) ? textureLod(EnvironmentBuffer, uv, 1.0f).xyz : vec3(0.0f));
#endif 
    FragColor = vec4(hdrValue, 1.0f);
}
