

#ifndef LINEARLY_TRANSFORMED_COSINES_H
#define LINEARLY_TRANSFORMED_COSINES_H



struct LtcRay
{
    vec3    m_origin;       
    vec3    m_direction;    
};










bool RayPlaneIntersect(in LtcRay ray, in vec4 plane, out float t)
{
    t = -dot(plane, vec4(ray.m_origin, 1.0f)) / dot(plane.xyz, ray.m_direction);

    return (t > 0.0f ? true : false);
}

 
 
 
 
 
 
 
vec3 IntegrateEdge(vec3 v1, vec3 v2)
{
    float x = dot(v1, v2);
    float y = abs(x);

    float a = 0.8543985f + (0.4965155f + 0.0145206f * y) * y;
    float b = 3.4175940f + (4.1616724f + y) * y;
    float v = a / b;

    float theta_sintheta = (x > 0.0f ? v : 0.5f * inversesqrt(max(1.0f - x * x, 1e-7f)) - v);

    return cross(v1, v2) * theta_sintheta;
}






void ClipQuadToHorizon(inout vec3 L[5], out int n)
{
    
    int config = 0;
    if(L[0].z > 0.0f) config += 1;
    if(L[1].z > 0.0f) config += 2;
    if(L[2].z > 0.0f) config += 4;
    if(L[3].z > 0.0f) config += 8;

    
    n = 0;

    if(config == 0)
    {
        
    }
    else if(config == 1)    
    {
        n = 3;
        L[1] = -L[1].z * L[0] + L[0].z * L[1];
        L[2] = -L[3].z * L[0] + L[0].z * L[3];
    }
    else if(config == 2)    
    {
        n = 3;
        L[0] = -L[0].z * L[1] + L[1].z * L[0];
        L[2] = -L[2].z * L[1] + L[1].z * L[2];
    }
    else if(config == 3)    
    {
        n = 4;
        L[2] = -L[2].z * L[1] + L[1].z * L[2];
        L[3] = -L[3].z * L[0] + L[0].z * L[3];
    }
    else if(config == 4)    
    {
        n = 3;
        L[0] = -L[3].z * L[2] + L[2].z * L[3];
        L[1] = -L[1].z * L[2] + L[2].z * L[1];
    }
    else if(config == 5)    
    {
        n = 0;
    }
    else if(config == 6)    
    {
        n = 4;
        L[0] = -L[0].z * L[1] + L[1].z * L[0];
        L[3] = -L[3].z * L[2] + L[2].z * L[3];
    }
    else if(config == 7)    
    {
        n = 5;
        L[4] = -L[3].z * L[0] + L[0].z * L[3];
        L[3] = -L[3].z * L[2] + L[2].z * L[3];
    }
    else if(config == 8)    
    {
        n = 3;
        L[0] = -L[0].z * L[3] + L[3].z * L[0];
        L[1] = -L[2].z * L[3] + L[3].z * L[2];
        L[2] = L[3];
    }
    else if(config == 9)    
    {
        n = 4;
        L[1] = -L[1].z * L[0] + L[0].z * L[1];
        L[2] = -L[2].z * L[3] + L[3].z * L[2];
    }
    else if(config == 10)   
    {
        n = 0;
    }
    else if(config == 11)   
    {
        n = 5;
        L[4] = L[3];
        L[3] = -L[2].z * L[3] + L[3].z * L[2];
        L[2] = -L[2].z * L[1] + L[1].z * L[2];
    }
    else if(config == 12)   
    {
        n = 4;
        L[1] = -L[1].z * L[2] + L[2].z * L[1];
        L[0] = -L[0].z * L[3] + L[3].z * L[0];
    }
    else if(config == 13)   
    {
        n = 5;
        L[4] = L[3];
        L[3] = L[2];
        L[2] = -L[1].z * L[2] + L[2].z * L[1];
        L[1] = -L[1].z * L[0] + L[0].z * L[1];
    }
    else if(config == 14)   
    {
        n = 5;
        L[4] = -L[0].z * L[3] + L[3].z * L[0];
        L[0] = -L[0].z * L[1] + L[1].z * L[0];
    }
    else if(config == 15)   
    {
        n = 4;
    }

    if(n == 3)
        L[3] = L[0];
    if(n == 4)
        L[4] = L[0];
}












vec3 FetchDiffuseFilteredTexture(in vec3 p1, in vec3 p2, in vec3 p3, in vec3 p4, in vec3 direction, in uint textureId)
{
    
    vec3 V1 = p2 - p1;
    vec3 V2 = p4 - p1;
    vec3 planeOrtho = cross(V1, V2);
    float planeAreaSquared = dot(planeOrtho, planeOrtho);

    LtcRay ray;
    float planeDist;
    ray.m_origin = vec3(0.0f);
    ray.m_direction = direction;
    vec4 plane = vec4(planeOrtho, -dot(planeOrtho, p1));
    RayPlaneIntersect(ray, plane, planeDist);
    vec3 P = planeDist * ray.m_direction - p1;

    
    vec2 Puv;
    float dot_V1_V2 = dot(V1, V2);
    float inv_dot_V1_V1 = 1.0f / dot(V1, V1);
    vec3 V2_ = V2 - V1 * dot_V1_V2 * inv_dot_V1_V1;
    Puv.y = dot(V2_, P) / dot(V2_, V2_);
    Puv.x = dot(V1, P) * inv_dot_V1_V1 - dot_V1_V2 * inv_dot_V1_V1 * Puv.y;

    
    float d = abs(planeDist) / pow(planeAreaSquared, 0.25f);

    
    Puv = Puv * vec2(1.0f, -1.0f) + vec2(0.0f, 1.0f);

    float lod = log(2048.0f * d) / log(3.0f);
    lod = min(lod, 7.0f);

    float lodA = floor(lod);
    float lodB = ceil(lod);
    float t = lod - lodA;

    vec3 a = SampleLevel(textureId, Puv, lodA).xyz;
    vec3 b = SampleLevel(textureId, Puv, lodB).xyz;

    return mix(a, b, t);
}










vec3 LTC_Evaluate(in vec3 P, in mat3 Minv, in vec3 points[4], in bool twoSided)
{
    
    vec3 L[5];
    L[0] = Minv * (points[0] - P);
    L[1] = Minv * (points[1] - P);
    L[2] = Minv * (points[2] - P);
    L[3] = Minv * (points[3] - P);

    vec3 LL[4];
    LL[0] = L[0];
    LL[1] = L[1];
    LL[2] = L[2];
    LL[3] = L[3];

    
    int n;
    ClipQuadToHorizon(L, n);
    if(n == 0)
        return vec3(0.0f);

    
    L[0] = normalize(L[0]);
    L[1] = normalize(L[1]);
    L[2] = normalize(L[2]);
    L[3] = normalize(L[3]);
    L[4] = normalize(L[4]);

    
    vec3 vsum = vec3(0.0f);
    vsum += IntegrateEdge(L[0], L[1]);
    vsum += IntegrateEdge(L[1], L[2]);
    vsum += IntegrateEdge(L[2], L[3]);
    if(n >= 4)
        vsum += IntegrateEdge(L[3], L[4]);
    if(n == 5)
        vsum += IntegrateEdge(L[4], L[0]);

    return vec3(twoSided ? abs(vsum.z) : max(vsum.z, 0.0f));
}









float LTC_Evaluate(in mat3 Minv, in float Mdet, in vec3 L)
{
    vec3 LCosine = Minv * L;
    float l2 = dot(LCosine, LCosine);
    float Jacobian = Mdet * Square(l2);

    return max(LCosine.z, 0.0f) / (FW_PI * Jacobian);
}









vec3 LTC_Sample(in vec3 M, in float Mdet, in vec2 s)
{
    float ct = sqrt(s.x);
    float st = sqrt(1.0f - s.x);
    float phi = 2.0f * FW_PI * s.y;

    vec3 dir = vec3(st * cos(phi), st * sin(phi), ct);

    vec3 L = M * dir;
    vec3 w_i = normalize(L);

    return w_i;
}

#endif 
