

#ifndef NOISE_H
#define NOISE_H







vec4 permute(in vec4 x)
{
    return mod(x * x * 34.0f + x, 289.0f);
}










float snoise(in vec3 v)
{
    const vec2 C = vec2(0.16666666666f, 0.33333333333f);
    const vec4 D = vec4(0.0f, 0.5f, 1.0f, 2.0f);
    vec3 i = floor(C.y * (v.x + v.y + v.z) + v);
    vec3 x0 = C.x * (i.x + i.y + i.z) + (v - i);
    vec3 g = step(x0.yzx, x0);
    vec3 l = (1.0f - g).zxy;
    vec3 i1 = min(g, l);
    vec3 i2 = max(g, l);
    vec3 x1 = x0 - i1 + C.x;
    vec3 x2 = x0 - i2 + C.y;
    vec3 x3 = x0 - D.yyy;
    i = mod(i, 289.0f);
    vec4 p = permute(permute(permute(
          i.z + vec4(0.0f, i1.z, i2.z, 1.0f))
        + i.y + vec4(0.0f, i1.y, i2.y, 1.0f))
        + i.x + vec4(0.0f, i1.x, i2.x, 1.0f));
    vec3 ns = 0.142857142857f * D.wyz - D.xzx;
    vec4 j = -49.0f * floor(p * ns.z * ns.z) + p;
    vec4 x_ = floor(j * ns.z);
    vec4 x = x_ * ns.x + ns.yyyy;
    vec4 y = floor(j - 7.0f * x_) * ns.x + ns.yyyy;
    vec4 h = 1.0f - abs(x) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 sh = -step(h, vec4(0.0f));
    vec4 a0 = b0.xzyw + (floor(b0) * 2.0f + 1.).xzyw * sh.xxyy;
    vec4 a1 = b1.xzyw + (floor(b1) * 2.0f + 1.).xzyw * sh.zzww;
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 norm = inversesqrt(vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3)));
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(0.6f - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), 0.0f);
    return 0.5f + 12.0f * dot(m * m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}







vec3 snoise3(in vec3 x)
{
    float s1 = snoise(vec3(x));
    float s2 = snoise(vec3(x.y - 19.1f, x.z + 33.4f,  x.x + 47.2f));
    float s3 = snoise(vec3(x.z + 74.2f, x.x - 124.5f, x.y + 99.4f));

    return vec3(s1, s2, s2);
}










vec3 CurlNoise(in vec3 p)
{
    const float eps = 1e-3f;

    vec3 dx = vec3(eps, 0.0f, 0.0f);
    vec3 dy = vec3(0.0f, eps, 0.0f);
    vec3 dz = vec3(0.0f, 0.0f, eps);

    vec3 p_x0 = snoise3(p - dx);
    vec3 p_x1 = snoise3(p + dx);
    vec3 p_y0 = snoise3(p - dy);
    vec3 p_y1 = snoise3(p + dy);
    vec3 p_z0 = snoise3(p - dz);
    vec3 p_z1 = snoise3(p + dz);

    float x = p_y1.z - p_y0.z - p_z1.y + p_z0.y;
    float y = p_z1.x - p_z0.x - p_x1.z + p_x0.z;
    float z = p_x1.y - p_x0.y - p_y1.x + p_y0.x;

    const float divisor = 1.0f / (2.0f * eps);

    return normalize(vec3(x, y, z) * divisor);
}







float FBM3(in vec3 v)
{
    float result = snoise(v);
    result += snoise(v * 2.0f) / 2.0f;
    result += snoise(v * 4.0f) / 4.0f;
    result /= (1.0f + 1.0f / 2.0f + 1.0f / 4.0f);
    return result;
}










float Perlin4D(in vec4 P)
{
    
    vec4 Pi = floor(P);
    vec4 Pf = P - Pi;
    vec4 Pf_min1 = Pf - 1.0f;

    
    Pi = Pi - floor(Pi * (1.0f / 69.0f)) * 69.0f;
    vec4 Pi_inc1 = step(Pi, vec4(69.0f - 1.5f)) * (Pi + 1.0f);

    
    const vec4 OFFSET = vec4(16.841230f, 18.774548f, 16.873274f, 13.664607f);
    const vec4 SCALE = vec4(0.102007f, 0.114473f, 0.139651f, 0.084550f);
    Pi = (Pi * SCALE) + OFFSET;
    Pi_inc1 = (Pi_inc1 * SCALE) + OFFSET;
    Pi *= Pi;
    Pi_inc1 *= Pi_inc1;
    vec4 x0y0_x1y0_x0y1_x1y1 = vec4(Pi.x, Pi_inc1.x, Pi.x, Pi_inc1.x) * vec4(Pi.yy, Pi_inc1.yy);
    vec4 z0w0_z1w0_z0w1_z1w1 = vec4(Pi.z, Pi_inc1.z, Pi.z, Pi_inc1.z) * vec4(Pi.ww, Pi_inc1.ww);
    const vec4 SOMELARGEFLOATS = vec4(56974.746094f, 47165.636719f, 55049.667969f, 49901.273438f);
    vec4 hashval = x0y0_x1y0_x0y1_x1y1 * z0w0_z1w0_z0w1_z1w1.xxxx;
    vec4 lowz_loww_hash_0 = fract(hashval * (1.0f / SOMELARGEFLOATS.x));
    vec4 lowz_loww_hash_1 = fract(hashval * (1.0f / SOMELARGEFLOATS.y));
    vec4 lowz_loww_hash_2 = fract(hashval * (1.0f / SOMELARGEFLOATS.z));
    vec4 lowz_loww_hash_3 = fract(hashval * (1.0f / SOMELARGEFLOATS.w));
    hashval = x0y0_x1y0_x0y1_x1y1 * z0w0_z1w0_z0w1_z1w1.yyyy;
    vec4 highz_loww_hash_0 = fract(hashval * (1.0f / SOMELARGEFLOATS.x));
    vec4 highz_loww_hash_1 = fract(hashval * (1.0f / SOMELARGEFLOATS.y));
    vec4 highz_loww_hash_2 = fract(hashval * (1.0f / SOMELARGEFLOATS.z));
    vec4 highz_loww_hash_3 = fract(hashval * (1.0f / SOMELARGEFLOATS.w));
    hashval = x0y0_x1y0_x0y1_x1y1 * z0w0_z1w0_z0w1_z1w1.zzzz;
    vec4 lowz_highw_hash_0 = fract(hashval * (1.0f / SOMELARGEFLOATS.x));
    vec4 lowz_highw_hash_1 = fract(hashval * (1.0f / SOMELARGEFLOATS.y));
    vec4 lowz_highw_hash_2 = fract(hashval * (1.0f / SOMELARGEFLOATS.z));
    vec4 lowz_highw_hash_3 = fract(hashval * (1.0f / SOMELARGEFLOATS.w));
    hashval = x0y0_x1y0_x0y1_x1y1 * z0w0_z1w0_z0w1_z1w1.wwww;
    vec4 highz_highw_hash_0 = fract(hashval * (1.0f / SOMELARGEFLOATS.x));
    vec4 highz_highw_hash_1 = fract(hashval * (1.0f / SOMELARGEFLOATS.y));
    vec4 highz_highw_hash_2 = fract(hashval * (1.0f / SOMELARGEFLOATS.z));
    vec4 highz_highw_hash_3 = fract(hashval * (1.0f / SOMELARGEFLOATS.w));

    
    lowz_loww_hash_0 -= 0.49999f;
    lowz_loww_hash_1 -= 0.49999f;
    lowz_loww_hash_2 -= 0.49999f;
    lowz_loww_hash_3 -= 0.49999f;
    highz_loww_hash_0 -= 0.49999f;
    highz_loww_hash_1 -= 0.49999f;
    highz_loww_hash_2 -= 0.49999f;
    highz_loww_hash_3 -= 0.49999f;
    lowz_highw_hash_0 -= 0.49999f;
    lowz_highw_hash_1 -= 0.49999f;
    lowz_highw_hash_2 -= 0.49999f;
    lowz_highw_hash_3 -= 0.49999f;
    highz_highw_hash_0 -= 0.49999f;
    highz_highw_hash_1 -= 0.49999f;
    highz_highw_hash_2 -= 0.49999f;
    highz_highw_hash_3 -= 0.49999f;

    vec4 grad_results_lowz_loww = inversesqrt(lowz_loww_hash_0 * lowz_loww_hash_0 + lowz_loww_hash_1 * lowz_loww_hash_1 + lowz_loww_hash_2 * lowz_loww_hash_2 + lowz_loww_hash_3 * lowz_loww_hash_3);
    grad_results_lowz_loww *= (vec2(Pf.x, Pf_min1.x).xyxy * lowz_loww_hash_0 + vec2(Pf.y, Pf_min1.y).xxyy * lowz_loww_hash_1 + Pf.zzzz * lowz_loww_hash_2 + Pf.wwww * lowz_loww_hash_3);

    vec4 grad_results_highz_loww = inversesqrt(highz_loww_hash_0 * highz_loww_hash_0 + highz_loww_hash_1 * highz_loww_hash_1 + highz_loww_hash_2 * highz_loww_hash_2 + highz_loww_hash_3 * highz_loww_hash_3);
    grad_results_highz_loww *= (vec2(Pf.x, Pf_min1.x).xyxy * highz_loww_hash_0 + vec2(Pf.y, Pf_min1.y).xxyy * highz_loww_hash_1 + Pf_min1.zzzz * highz_loww_hash_2 + Pf.wwww * highz_loww_hash_3);

    vec4 grad_results_lowz_highw = inversesqrt(lowz_highw_hash_0 * lowz_highw_hash_0 + lowz_highw_hash_1 * lowz_highw_hash_1 + lowz_highw_hash_2 * lowz_highw_hash_2 + lowz_highw_hash_3 * lowz_highw_hash_3);
    grad_results_lowz_highw *= (vec2(Pf.x, Pf_min1.x).xyxy * lowz_highw_hash_0 + vec2(Pf.y, Pf_min1.y).xxyy * lowz_highw_hash_1 + Pf.zzzz * lowz_highw_hash_2 + Pf_min1.wwww * lowz_highw_hash_3);

    vec4 grad_results_highz_highw = inversesqrt(highz_highw_hash_0 * highz_highw_hash_0 + highz_highw_hash_1 * highz_highw_hash_1 + highz_highw_hash_2 * highz_highw_hash_2 + highz_highw_hash_3 * highz_highw_hash_3);
    grad_results_highz_highw *= (vec2(Pf.x, Pf_min1.x).xyxy * highz_highw_hash_0 + vec2(Pf.y, Pf_min1.y).xxyy * highz_highw_hash_1 + Pf_min1.zzzz * highz_highw_hash_2 + Pf_min1.wwww * highz_highw_hash_3);

    
    vec4 blend = Pf * Pf * Pf * (Pf * (Pf * 6.0f - 15.0f) + 10.0f);
    vec4 res0 = grad_results_lowz_loww + (grad_results_lowz_highw - grad_results_lowz_loww) * blend.wwww;
    vec4 res1 = grad_results_highz_loww + (grad_results_highz_highw - grad_results_highz_loww) * blend.wwww;
    res0 = res0 + (res1 - res0) * blend.zzzz;
    blend.zw = 1.0f - blend.xy;

    return dot(res0, blend.zxzx * blend.wwyy);
}







vec3 Perlin4D_3x(in vec4 P)
{
    float s1 = Perlin4D(vec4(P));
    float s2 = Perlin4D(vec4(P.y - 19.1f, P.z + 33.4f, P.x + 47.2f, P.w));
    float s3 = Perlin4D(vec4(P.z + 74.2f, P.x - 124.5f, P.y + 99.4f, P.w));

    return vec3(s1, s2, s2);
}

#endif 
