

#include "Shader.h"
#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;                                 
layout(std430) buffer           ConstantBuffer { vec4 constantBuffer[]; };  
uniform sampler2D               DepthBuffer;                                
uniform sampler2D               ColorBuffer;                                
uniform shader                  PixelShader;                                
uniform uint                    Texture;                                    
uniform float                   TextureAspect;                              
uniform float                   Intensity;                                  
uniform uint                    BlendMode;                                  
uniform float                   BlendAmount;                                
uniform uint                    BlendChannels;                              
out vec4                        FragColor;                                  







vec3 ToLDR(in vec3 hdr)
{
    return hdr / (1.0f + hdr);
}







vec3 ToHDR(in vec3 ldr)
{
    return ldr / max(1.0f - ldr, 1e-3f);
}

_kernel


void Overlay()
{
    const float aspect = (Aspect / TextureAspect);
    vec2 ndc = (2.0f * vTexcoords - 1.0f);
    if(aspect > 1.0f) ndc.y /= aspect;
                 else ndc.x *= aspect;
    const vec2 uv = 0.5f * ndc + 0.5f;  
    vec4 dst = textureLod(ColorBuffer, vTexcoords, 0.0f);
    vec4 src = Sample(Texture, uv);
    dst.xyz = ToLDR(dst.xyz);
    PixelShader(vTexcoords, src);
    src.xyz = pow(clamp(src.xyz, 0.0f, 1.0f), vec3(2.2f));
    src.xyz = ToLDR(Intensity * src.xyz);   
    const float blendAmount = BlendAmount * clamp(src.w, 0.0f, 1.0f);
    dst = Blend(vec4(dst.xyz, 1.0f), vec4(src.xyz, 1.0f), BlendMode, blendAmount, BlendChannels);
    FragColor = vec4(ToHDR(dst.xyz), 1.0f);
}
