

#ifndef PARTICLE_BUFFERS_H
#define PARTICLE_BUFFERS_H








vec3 ReadVelocity(in uint particleIndex, in uint emitterIndex)
{
    if((perEmitterFlagsBuffer[emitterIndex] & (1u << 0)) != 0)
        return velocityBuffer[particleIndex].xyz;
    vec3 velocity = initialVelocityBuffer[particleIndex].xyz;
    if(dot(velocity, velocity) != 0.0f)
    {
        const float t = ageBuffer[particleIndex] / lifeBuffer[particleIndex];
        const uvec2 packedCoefficients = velocityAgeCoefficientsBuffer[particleIndex];
        const vec4 ageCoefficients = vec4(unpackHalf2x16(packedCoefficients.x), unpackHalf2x16(packedCoefficients.y));
        const float v = pow(1.0f - t, 3.0f) * ageCoefficients.x + 3.0f * pow(1.0f - t, 2.0f) * t * ageCoefficients.y
                      + 3.0f * (1.0f - t) * pow(t, 2.0f) * ageCoefficients.z + pow(t, 3.0f) * ageCoefficients.w;
        velocity *= clamp(v, 0.0f, 1.0f);   
    }
    return velocity;
}

#endif 
