

#include "ShaderCore.h"

layout(lines)                           in;                                             
layout(line_strip, max_vertices = 24)   out;                                            
layout(std430) buffer                   GridAABBBuffer  { AABB gridAABBBuffer[];  };    
layout(std430) buffer                   GridCountBuffer { uint gridCountBuffer[]; };    
layout(std430) buffer                   GridTileBuffer  { uint gridTileBuffer[];  };    
uniform float                           CellSize;                                       
uniform uint                            TileSize;                                       
flat in uint                            vInstanceId[];                                  
flat out uint                           vParticleCount;                                 








uvec3 To3D(in uint index, in uvec3 count)
{
    return uvec3(
        index % count.x,
        (index / count.x) % count.y,
        index / (count.x * count.y));
}







uvec3 GetParticleGridRes(in AABB aabb)
{
    const float tileSize = (CellSize * TileSize);
    const vec3 aabbExtents = (aabb.m_maxBounds.xyz - aabb.m_minBounds.xyz);
    return uvec3(aabbExtents / tileSize + 0.5f);
}

_kernel


void DebugParticleGrid()
{
    const uint cellCount = (TileSize * TileSize * TileSize);
    const uint tileIndex = (vInstanceId[0] / cellCount);
    const uint localIndex = (vInstanceId[0] % cellCount);
    const uint tileAddress = gridTileBuffer[tileIndex];
    if(tileAddress == uint(-1))
        return; 
    const uint globalIndex = localIndex + tileAddress * cellCount;
    vParticleCount = gridCountBuffer[globalIndex];
    if(vParticleCount == 0)
        return; 
    AABB aabb = gridAABBBuffer[0];
    const uvec3 gridRes = GetParticleGridRes(aabb);
    const uvec3 gridPos = To3D(localIndex, uvec3(TileSize)) + To3D(tileIndex, gridRes) * TileSize;
    const vec3 pos = aabb.m_minBounds.xyz + gridPos * CellSize;
    {
        
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, 0.0f, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, 0.0f, 0.0f), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, 0.0f, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, CellSize, 0.0f), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, CellSize, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, CellSize, 0.0f), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, CellSize, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, 0.0f, 0.0f), 1.0f);
        EmitVertex();
        EndPrimitive();
    }
    {
        
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, 0.0f, CellSize), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, 0.0f, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, 0.0f, CellSize), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, CellSize, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, CellSize, CellSize), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, CellSize, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, CellSize, CellSize), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, 0.0f, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
    }
    {
        
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, 0.0f, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, 0.0f, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, 0.0f, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, 0.0f, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, CellSize, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(CellSize, CellSize, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, CellSize, 0.0f), 1.0f);
        EmitVertex();
        gl_Position = ViewProjection * vec4(pos + vec3(0.0f, CellSize, CellSize), 1.0f);
        EmitVertex();
        EndPrimitive();
    }
}
