

layout(triangles)                            in;                                
layout(triangle_strip, max_vertices = 3)     out;                               
layout(std430) buffer   InstanceIndexBuffer { uint  instanceIndexBuffer[]; };   
layout(std430) buffer   TriangleAreaBuffer  { float triangleAreaBuffer[];  };   
layout(std430) buffer   TriangleCountBuffer { uint  triangleCountBuffer[]; };   
layout(std430) buffer   TriangleIndexBuffer { float triangleIndexBuffer[]; };   
uniform uint            MaxTriangleCount;                                       
uniform uint            InstanceCount;                                          
flat in uint            vDrawId[];                                              

_kernel


void WriteTriangleBuffer()
{
    const uint triangleIndex = instanceIndexBuffer[vDrawId[0]] + gl_PrimitiveIDIn;
    if(triangleIndex >= MaxTriangleCount)
        return; 
    const vec3 v0 = gl_in[0].gl_Position.xyz;
    const vec3 v1 = gl_in[1].gl_Position.xyz;
    const vec3 v2 = gl_in[2].gl_Position.xyz;
    const float triangleArea = 0.5f * length(cross(v2 - v0, v1 - v0));
    if(triangleIndex == MaxTriangleCount - 1 || 
      ((vDrawId[0] + 1) == InstanceCount && (gl_PrimitiveIDIn + 1) == triangleCountBuffer[0]))
        triangleAreaBuffer[0] = triangleArea;   
    triangleIndexBuffer[triangleIndex] = triangleArea;
}
