

#include "ShaderCore.h"

layout(std430) buffer   MeshDataBuffer { MeshData meshDataBuffer[]; };  
flat out uint           vDrawId;                                        

_kernel


void WriteTriangleBuffer()
{
    MeshData meshData = meshDataBuffer[iDrawId];
    mat4 matrix = GetTransform(meshData);
    gl_Position = matrix * vec4(Position, 1.0f);
    vDrawId = uDrawId;
}
