

#include "ShaderCore.h"

flat in float   vParticleAge;       
in vec4         vParticleColor;     
flat in vec3    vParticleCenter;    
uniform vec4    Params;             
uniform float   BlobSmoothness;     
uniform uint    ParticleTexture;    
out vec4        FragColor;          

_kernel


void RenderLine()
{
    FragColor = vec4(vParticleColor.xyz * vParticleColor.w, vParticleColor.w);
}

_kernel


void RenderPoint()
{
    float blobFactor = 1.0f;
    vec4 particleColor = vParticleColor;
    const vec2 uv = gl_FragCoord.xy * ViewportWidthHeightInverse * vec2(Aspect, 1.0f);
    if(BlobSmoothness > 0.0f)
    {
        blobFactor -= distance(uv, vParticleCenter.xy) / vParticleCenter.z;
        blobFactor = smoothstep(0.0f, BlobSmoothness, blobFactor);
    }
    if(ParticleTexture != uint(-1))
    {
        const uvec2 spriteSheet = floatBitsToUint(Params.zw);
        const vec2 uv = 0.5f * (uv - vParticleCenter.xy) / vParticleCenter.z + 0.5f;
        const float spriteIndex = min(vParticleAge * spriteSheet.x * spriteSheet.y, spriteSheet.x * spriteSheet.y - 1.0f);
        const uint spriteIndexLo = uint(floor(spriteIndex)), spriteIndexHi = uint(ceil(spriteIndex));
        const uvec2 spriteLo = uvec2(spriteIndexLo % spriteSheet.x, spriteSheet.y - spriteIndexLo / spriteSheet.x);
        const uvec2 spriteHi = uvec2(spriteIndexHi % spriteSheet.x, spriteSheet.y - spriteIndexHi / spriteSheet.x);
        const vec2 uvLo = (uv + spriteLo) / spriteSheet, uvHi = (uv + spriteHi) / spriteSheet;
        const vec4 spriteColor = mix(Sample(ParticleTexture, uvLo), Sample(ParticleTexture, uvHi), fract(spriteIndex));
        particleColor *= vec4(pow(spriteColor.xyz, vec3(2.2f)), spriteColor.w);
    }
    FragColor = vec4(particleColor.xyz * particleColor.w, particleColor.w) * blobFactor;
}
