

#include "Raytrace.h"
#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;                                             
layout(std430) buffer           VolumeAABBBuffer    { AABB  volumeAABBBuffer[];    };   
layout(std430) buffer           VolumeTileBuffer    { uint  volumeTileBuffer[];    };   
layout(std430) buffer           VolumeDensityBuffer { float volumeDensityBuffer[]; };   
uniform float                   CellSize;                                               
uniform uint                    TileSize;                                               
uniform uint                    MaxTileCount;                                           
out vec4                        FragColor;                                              










float fmin(in float a, in float b)
{
    return (a < b || b != b ? a : b);
}








uint To1D(in uvec3 index, in uvec3 count)
{
    return index.x + (index.y + index.z * count.y) * count.x;
}







uvec3 GetParticleGridRes(in AABB aabb)
{
    const vec3 aabbExtents = (aabb.m_maxBounds.xyz - aabb.m_minBounds.xyz);
    const float tileSize = (CellSize * TileSize);
    return uvec3(aabbExtents / tileSize + 0.5f);
}








float CopySign(in float a, in float b)
{
    return (sign(b) >= 0.0f ? a : -a);
}







vec3 GetInverseDirection(in vec3 d)
{
    vec3 invdir;
    float dirx = d.x;
    float diry = d.y;
    float dirz = d.z;
    float ooeps = 1e-5f;
    invdir.x = 1.0f / (abs(dirx) > ooeps ? dirx : CopySign(ooeps, dirx));
    invdir.y = 1.0f / (abs(diry) > ooeps ? diry : CopySign(ooeps, diry));
    invdir.z = 1.0f / (abs(dirz) > ooeps ? dirz : CopySign(ooeps, dirz));
    return invdir;
}











ivec4 GetCell(in AABB aabb, in vec3 position, in vec3 direction, in float travelled_t, out float payload)
{
    const vec3 point = (position + travelled_t * direction);
    const ivec3 tile = ivec3(floor(point / (CellSize * TileSize)));
    const uint tileIndex = (all(greaterThanEqual(tile, ivec3(0))) ? To1D(tile, GetParticleGridRes(aabb)) : uint(-1));
    const uint tileAddress = (tileIndex < MaxTileCount ? volumeTileBuffer[tileIndex] : uint(-1));
    if(tileAddress == uint(-1))
    {
        payload = 0;    
        return ivec4(tile * TileSize, TileSize);
    }
    const ivec3 cell = ivec3(floor(point / CellSize));
    const uint cellIndex = To1D(cell - tile * TileSize, uvec3(TileSize));
    payload = volumeDensityBuffer[cellIndex + tileAddress * TileSize * TileSize * TileSize];
    return ivec4(cell, 1);  
}

_kernel


void DebugParticleTiles()
{
    AABB aabb = volumeAABBBuffer[0];
    const vec2 ndc = 2.0f * vTexcoords - 1.0f;
    vec4 worldPosition = ViewProjectionInverse * vec4(ndc, 0.0f, 1.0f);
    worldPosition.xyz /= worldPosition.w;   
    const vec3 direction = normalize(worldPosition.xyz - Eye),
               directionInverse = GetInverseDirection(direction);
    vec3 position = Eye;    
    if(any(lessThan(position, aabb.m_minBounds.xyz)) || any(greaterThan(position, aabb.m_maxBounds.xyz)))
    {
        float rayIntersectionDistance;
        if(!RayIntersectBoxTest(aabb.m_minBounds.xyz, aabb.m_maxBounds.xyz, position, directionInverse, rayIntersectionDistance))
        {
            FragColor = vec4(0.0f, 0.0f, 0.0f, 1.0f);
            return; 
        }
        position += rayIntersectionDistance * direction;
    }
    float stepCount = 0;
    float payload, travelled_t = 0.0f;
    position = max(position - aabb.m_minBounds.xyz, 0.0f);
    const uvec3 gridRes = GetParticleGridRes(aabb) * TileSize;
    ivec4 cell = GetCell(aabb, position, direction, travelled_t, payload);
    do
    {
        stepCount += payload;
        const ivec3 cellPoint = ivec3(
            cell.x + (direction.x >= 0.0f ? cell.w : 0),
            cell.y + (direction.y >= 0.0f ? cell.w : 0),
            cell.z + (direction.z >= 0.0f ? cell.w : 0));
        const vec3 tcell = (cellPoint * CellSize - position) * directionInverse;
        travelled_t = fmin(tcell.x, fmin(tcell.y, tcell.z));    
        const ivec4 exitPoint = GetCell(aabb, position, direction, travelled_t, payload);
        const ivec3 nextCell = ivec3(
            travelled_t == tcell.x ? cellPoint.x + (direction.x >= 0.0f ? 0 : -1) : exitPoint.x,
            travelled_t == tcell.y ? cellPoint.y + (direction.y >= 0.0f ? 0 : -1) : exitPoint.y,
            travelled_t == tcell.z ? cellPoint.z + (direction.z >= 0.0f ? 0 : -1) : exitPoint.z);
        cell.x = (direction.x >= 0.0f ? max(nextCell.x, cell.x) : min(nextCell.x, cell.x));
        cell.y = (direction.y >= 0.0f ? max(nextCell.y, cell.y) : min(nextCell.y, cell.y));
        cell.z = (direction.z >= 0.0f ? max(nextCell.z, cell.z) : min(nextCell.z, cell.z));
        cell.w = exitPoint.w;
    }
    while(all(greaterThanEqual(cell.xyz, ivec3(0))) && all(lessThan(cell.xyz, ivec3(gridRes))));
    FragColor = vec4(ViridisQuintic(clamp(stepCount / 2e2f, 0.0f, 1.0f)), 1.0f);
}
