

#ifndef PHOTON_MAPPING_H
#define PHOTON_MAPPING_H

#include "ShaderSharedCode.h"



struct Photon
{
    vec3    m_position;     
    vec3    m_direction;    
    vec3    m_power;        
    float   m_size;         
};







vec3 PhotonGetPosition(in PhotonData photon)
{
    return photon.m_position.xyz;
}






void PhotonSetPosition(inout PhotonData photon, in vec3 position)
{
    photon.m_position.xyz = position;
}







vec3 PhotonGetDirection(in PhotonData photon)
{
    return normalize(2.0f * unpackUnorm4x8(floatBitsToUint(photon.m_position.w)).xyz - 1.0f);
}








void PhotonSetDirection(inout PhotonData photon, in vec3 direction)
{
    photon.m_position.w = uintBitsToFloat(packUnorm4x8(vec4(0.5f * direction + 0.5f, 0.0f)));
}







vec3 PhotonGetPower(in PhotonData photon)
{
    return unpackUnorm4x8(floatBitsToUint(photon.m_photonData.x)).xyz * photon.m_photonData.y;
}






void PhotonSetPower(inout PhotonData photon, in vec3 power)
{
    const float intensity = max(power.x, max(power.y, max(power.z, 1e-6f)));
    photon.m_photonData.x = uintBitsToFloat(packUnorm4x8(vec4(power / intensity, 1.0f)));
    photon.m_photonData.y = intensity;
}







float PhotonGetSize(in PhotonData photon)
{
    return photon.m_photonData.z;
}






void PhotonSetSize(inout PhotonData photon, in float size)
{
    photon.m_photonData.z = size;
}







Photon GetPhoton(in PhotonData photonData)
{
    Photon photon;
    photon.m_position = PhotonGetPosition(photonData);
    photon.m_direction = PhotonGetDirection(photonData);
    photon.m_power = PhotonGetPower(photonData);
    photon.m_size = PhotonGetSize(photonData);
    return photon;
}







PhotonData ToPhotonData(in Photon photon)
{
    PhotonData photonData;
    PhotonSetPosition(photonData, photon.m_position);
    PhotonSetDirection(photonData, photon.m_direction);
    PhotonSetPower(photonData, photon.m_power);
    PhotonSetSize(photonData, photon.m_size);
    return photonData;
}

#endif 
