

#include "ShaderCore.h"

#define FXAA_PC 1
#define FXAA_GLSL_130 1
#define FXAA_QUALITY__PRESET 12

#include "Vendor/Fxaa3_11/Fxaa3_11.h"
#include "Vendor/notorious6/brightness-hue-preserving.glsl"

noperspective sample in vec2                vTexcoords;         
uniform sampler2D                           ColorBuffer;        
uniform sampler2D                           DepthBuffer;        
uniform sampler2D                           HistoryBuffer;      
layout(rgba16f) writeonly uniform image2D   RWHistoryBuffer;    
uniform sampler2D                           VelocityBuffer;     
out vec4                                    FragColor;          





vec4 ApplyAntiAliasing()
{
    FxaaFloat2 pos = vTexcoords;

    FxaaFloat4 fxaaConsolePosPos = FxaaFloat4(0.0f);
    FxaaFloat2 fxaaQualityRcpFrame = ViewportWidthHeightInverse;
    FxaaFloat4 fxaaConsoleRcpFrameOpt = FxaaFloat4(0.0f);
    FxaaFloat4 fxaaConsoleRcpFrameOpt2 = FxaaFloat4(0.0f);
    FxaaFloat4 fxaaConsole360RcpFrameOpt2 = FxaaFloat4(0.0f);
    FxaaFloat  fxaaQualitySubpix = 0.75f;
    FxaaFloat  fxaaQualityEdgeThreshold = 0.166f;
    FxaaFloat  fxaaQualityEdgeThresholdMin = 0.0833f;
    FxaaFloat  fxaaConsoleEdgeSharpness = 8.0f;
    FxaaFloat  fxaaConsoleEdgeThreshold = 0.125f;
    FxaaFloat  fxaaConsoleEdgeThresholdMin = 0.05f;
    FxaaFloat4 fxaaConsole360ConstDir = FxaaFloat4(0.0f);

    return FxaaPixelShader(
        pos,
        fxaaConsolePosPos,
        ColorBuffer,
        ColorBuffer,
        ColorBuffer,
        fxaaQualityRcpFrame,
        fxaaConsoleRcpFrameOpt,
        fxaaConsoleRcpFrameOpt2,
        fxaaConsole360RcpFrameOpt2,
        fxaaQualitySubpix,
        fxaaQualityEdgeThreshold,
        fxaaQualityEdgeThresholdMin,
        fxaaConsoleEdgeSharpness,
        fxaaConsoleEdgeThreshold,
        fxaaConsoleEdgeThresholdMin,
        fxaaConsole360ConstDir);
}










vec4 ApplyToneMapping(in vec4 color)
{
    color.xyz *= 4.0f;  
    ShaderInput shaderInput;
    shaderInput.uv = vTexcoords;
    shaderInput.stimulus = max(color.xyz, 1e-37f);
    return vec4(compress_stimulus(shaderInput), color.w);
}














vec4 ApplySharpening(in vec4 center, in vec4 top, in vec4 left, in vec4 right, in vec4 bottom)
{
    float accum = 0.0f;
    float weight = 0.0f;

    const float sharpenAmount = 0.25f;
    float result = sqrt(GetLuminance(center.xyz));
    {
        const float n0 = sqrt(GetLuminance(top.xyz));
        const float n1 = sqrt(GetLuminance(bottom.xyz));
        const float n2 = sqrt(GetLuminance(left.xyz));
        const float n3 = sqrt(GetLuminance(right.xyz));

        float w0 = max(1.0f - 6.0f * (abs(result - n0) + abs(result - n1)), 0.0f);
        float w1 = max(1.0f - 6.0f * (abs(result - n2) + abs(result - n3)), 0.0f);
        w0 = min(1.25f * sharpenAmount * w0, w0);
        w1 = min(1.25f * sharpenAmount * w1, w1);

        accum += n0 * w0;
        accum += n1 * w0;
        accum += n2 * w1;
        accum += n3 * w1;

        weight += 2.0f * w0;
        weight += 2.0f * w1;
    }
    result = max(result * (weight + 1.0f) - accum, 0.0f);
    result = Square(result);

    return vec4(min(center.xyz * result / max(GetLuminance(center.xyz), 1e-5f), 1.0f), center.w);
}







float NRand(in vec2 uv)
{
    return fract(sin(dot(uv.xy, vec2(12.9898f, 78.233f))) * 43758.5453f);
}










vec3 GetNoise(in vec2 uv, in uint seed)
{
    const float t = 0.001f * float(seed);

    const float nrnd0 = NRand(uv + 0.07f * t);
    const float nrnd1 = NRand(uv + 0.11f * t);
    const float nrnd2 = NRand(uv + 0.13f * t);
    const float nrnd3 = NRand(uv + 0.17f * t);
    const float nrnd4 = NRand(uv + 0.19f * t);
    const float nrnd5 = NRand(uv + 0.23f * t);

    return vec3(
        0.5f * (nrnd0 + nrnd1),
        0.5f * (nrnd2 + nrnd3),
        0.5f * (nrnd4 + nrnd5));
}








void GetDitherNoise(out vec3 noise0, out vec3 noise1, out vec3 noise2, out vec3 noise3)
{
    noise0 = GetNoise(vTexcoords, (Frame + 0) & 0xFFu);
    noise1 = GetNoise(vTexcoords, (Frame + 1) & 0xFFu);
    noise2 = GetNoise(vTexcoords, (Frame + 2) & 0xFFu);
    noise3 = GetNoise(vTexcoords, (Frame + 3) & 0xFFu);
}







vec3 DitherColor(in vec3 color)
{
    vec3 noise0, noise1, noise2, noise3;
    GetDitherNoise(noise0, noise1, noise2, noise3);
    noise0 = 10.0f * (2.0f * noise0 - 1.0f) / 255.0f;
    noise1 = 10.0f * (2.0f * noise1 - 1.0f) / 255.0f;
    noise2 = 10.0f * (2.0f * noise2 - 1.0f) / 255.0f;
    noise3 = 10.0f * (2.0f * noise3 - 1.0f) / 255.0f;
    return color + 0.15f * (noise0 + noise1 + noise2 + noise3);
}







float SquareLength(in vec2 value)
{
    return (value.x * value.x + value.y * value.y);
}







vec2 GetClosestVelocity(out bool isSkyPixel)
{
    vec2 velocity;
    float closestDepth = 9.9f;
    for(int y = -1; y <= 1; ++y)
        for(int x = -1; x <= 1; ++x)
        {
            vec2 uv = vTexcoords + vec2(x, y) * ViewportWidthHeightInverse;
            float depth = texture(DepthBuffer, uv).x;
            if(depth < closestDepth)
            {
                velocity = texture(VelocityBuffer, uv).xy;
                closestDepth = depth;
            }
        }
    isSkyPixel = (closestDepth >= 1.0f);    
    vec4 previousUv = Reprojection * vec4(2.0f * vec3(vTexcoords, closestDepth) - 1.0f, 1.0f);
    previousUv = 0.5f * previousUv / previousUv.w + 0.5f;   
    return vTexcoords - previousUv.xy + velocity;
}










vec3 SampleHistoryCatmullRom(in vec2 uv)
{
    
    
    
    vec2 samplePos = uv * ViewportWidthHeight;
    vec2 texPos1 = floor(samplePos - 0.5f) + 0.5f;

    
    
    vec2 f = samplePos - texPos1;

    
    
    
    vec2 w0 = f * (-0.5f + f * (1.0f - 0.5f * f));
    vec2 w1 = 1.0f + f * f * (-2.5f + 1.5f * f);
    vec2 w2 = f * (0.5f + f * (2.0f - 1.5f * f));
    vec2 w3 = f * f * (-0.5f + 0.5f * f);

    
    
    vec2 w12 = w1 + w2;
    vec2 offset12 = w2 / (w1 + w2);

    
    vec2 texPos0 = texPos1 - 1.0f;
    vec2 texPos3 = texPos1 + 2.0f;
    vec2 texPos12 = texPos1 + offset12;

    texPos0 *= ViewportWidthHeightInverse;
    texPos3 *= ViewportWidthHeightInverse;
    texPos12 *= ViewportWidthHeightInverse;

    vec3 result = vec3(0.0f);

    result += texture(HistoryBuffer, vec2(texPos0.x, texPos0.y)).xyz * w0.x * w0.y;
    result += texture(HistoryBuffer, vec2(texPos12.x, texPos0.y)).xyz * w12.x * w0.y;
    result += texture(HistoryBuffer, vec2(texPos3.x, texPos0.y)).xyz * w3.x * w0.y;

    result += texture(HistoryBuffer, vec2(texPos0.x, texPos12.y)).xyz * w0.x * w12.y;
    result += texture(HistoryBuffer, vec2(texPos12.x, texPos12.y)).xyz * w12.x * w12.y;
    result += texture(HistoryBuffer, vec2(texPos3.x, texPos12.y)).xyz * w3.x * w12.y;

    result += texture(HistoryBuffer, vec2(texPos0.x, texPos3.y)).xyz * w0.x * w3.y;
    result += texture(HistoryBuffer, vec2(texPos12.x, texPos3.y)).xyz * w12.x * w3.y;
    result += texture(HistoryBuffer, vec2(texPos3.x, texPos3.y)).xyz * w3.x * w3.y;

    return max(result, 0.0f);
}

_kernel


void Resolve()
{
    vec4 color = texture(ColorBuffer, vTexcoords);
#ifdef TONE_MAPPING
    color = ApplyToneMapping(color);
#endif 
    const float luminance = GetLuminance(color.xyz);
#ifdef USE_SHARPENING
    vec4 top    = texture(ColorBuffer, vTexcoords + vec2( 0.0f,  1.0f) * ViewportWidthHeightInverse);
    vec4 left   = texture(ColorBuffer, vTexcoords + vec2(-1.0f,  0.0f) * ViewportWidthHeightInverse);
    vec4 right  = texture(ColorBuffer, vTexcoords + vec2( 1.0f,  0.0f) * ViewportWidthHeightInverse);
    vec4 bottom = texture(ColorBuffer, vTexcoords + vec2( 0.0f, -1.0f) * ViewportWidthHeightInverse);
#ifdef TONE_MAPPING
    top    = ApplyToneMapping(top);
    left   = ApplyToneMapping(left);
    right  = ApplyToneMapping(right);
    bottom = ApplyToneMapping(bottom);
#endif 
    color = ApplySharpening(color, top, left, right, bottom);
#endif 
#ifdef COLOR_DITHERING
    color.xyz = DitherColor(color.xyz);
#endif 
    FragColor = vec4(color.xyz, luminance);
}

_kernel


void Reproject()
{
    bool isSkyPixel;

    const vec2 offsets[8] =
    {
        vec2(-1.0f, -1.0f),
        vec2(-1.0f,  0.0f),
        vec2(-1.0f,  1.0f),
        vec2( 0.0f, -1.0f),
        vec2( 0.0f,  1.0f),
        vec2( 1.0f, -1.0f),
        vec2( 1.0f,  0.0f),
        vec2( 1.0f,  1.0f)
    };

    vec3 vsum = textureLod(ColorBuffer, vTexcoords, 0.0f).xyz;
    vec3 vsum2 = vsum * vsum;
    float wsum = 1.0f;

    vec3 nmin = vsum;
    vec3 nmax = vsum;

    for(uint i = 0; i < 8; ++i)
    {
        vec3 neigh = textureLod(ColorBuffer, vTexcoords + offsets[i] * ViewportWidthHeightInverse, 0.0f).xyz;
        float w = exp(-3.0f * SquareLength(offsets[i]) / 4.0f);
        nmin = min(neigh, nmin); nmax = max(neigh, nmax);
        vsum2 += neigh * neigh * w;
        vsum += neigh * w;
        wsum += w;
    }

    vec3 ex = vsum / wsum;
    vec3 ex2 = vsum2 / wsum;
    vec3 dev = sqrt(max(ex2 - ex * ex, 0.0f));

    vec2 velocity = GetClosestVelocity(isSkyPixel);
    float boxSize = mix(0.5f, 2.5f, isSkyPixel ? 0.0f : smoothstep(0.02f, 0.0f, length(velocity)));

    nmin = max(ex - dev * boxSize, nmin);
    nmax = min(ex + dev * boxSize, nmax);

    vec3 history = SampleHistoryCatmullRom(vTexcoords - velocity);
    vec3 clampedHistory = clamp(history, nmin, nmax);
    vec3 center = texture(ColorBuffer, vTexcoords).xyz;
    vec3 result = mix(clampedHistory, center, 1.0f / 16.0f);

    FragColor = vec4(result, GetLuminance(result));
}

_kernel


void Present()
{
    const ivec2 pos = iPixel;
#ifdef ANTI_ALIASING
    vec4 color = ApplyAntiAliasing();
#else 
    vec4 color = texelFetch(ColorBuffer, pos, 0);
#endif 
#ifdef TEMPORAL_REPROJECTION
#ifdef ANTI_ALIASING
    const vec4 taaColor = texelFetch(ColorBuffer, pos, 0);
    imageStore(RWHistoryBuffer, pos, vec4(taaColor.xyz, 1.0f));
#else 
    imageStore(RWHistoryBuffer, pos, vec4(color.xyz, 1.0f));
#endif 
#endif 
#ifdef USE_SHARPENING
    const ivec2 edge = ivec2(ViewportWidthHeight) - 1;
    vec4 top    = texelFetch(ColorBuffer, clamp(pos + ivec2( 0,  1), ivec2(0), edge), 0);
    vec4 left   = texelFetch(ColorBuffer, clamp(pos + ivec2(-1,  0), ivec2(0), edge), 0);
    vec4 right  = texelFetch(ColorBuffer, clamp(pos + ivec2( 1,  0), ivec2(0), edge), 0);
    vec4 bottom = texelFetch(ColorBuffer, clamp(pos + ivec2( 0, -1), ivec2(0), edge), 0);
    color = ApplySharpening(color, top, left, right, bottom);
#endif 
#ifdef COLOR_DITHERING
    color.xyz = DitherColor(color.xyz);
#endif 
    FragColor = vec4(color.xyz, 1.0f);
}
