

#include "Shader.h"
#include "ShaderCore.h"



#define USE_DISSOLVE_SHADER

layout(location = 0) out vec4   AlbedoOut;                                                  
layout(location = 1) out vec4   NormalOut;                                                  
in vec3                         vNormal;                                                    
flat in vec2                    vMeshData;                                                  
flat in uint                    vMaterialId;                                                
in vec2                         vTexcoords;                                                 
in vec3                         vObjectPosition;                                            
in vec3                         vWorldPosition;                                             
uniform mat4                    ViewMatrix;                                                 
uniform mat4                    ViewProjectionMatrix;                                       
uniform sampler2D               AlbedoBuffer;                                               
uniform sampler2D               NormalBuffer;                                               
uniform sampler2D               DepthBuffer;                                                
layout(std430) buffer           ConstantBuffer         { vec4 constantBuffer[];         };  
layout(std430) buffer           DissolveConstantBuffer { vec4 dissolveConstantBuffer[]; };  
uniform shader                  DissolveShader;                                             
uniform shader                  MaterialShader;                                             
out vec4                        FragColor;                                                  

#include "StochasticDissolve.h"





void MaterialApplyShader(inout Material material)
{
    Surface surface;
    surface.m_texcoords = vTexcoords;
    surface.m_normal = normalize(vNormal);
    surface.m_objectPosition = vObjectPosition;
    surface.m_worldPosition = vWorldPosition;
    MaterialShader(surface, material);
}

_kernel


void DrawRSM()
{
    StochasticAlphaTesting(false);
    const vec3 normal = normalize(vNormal);
    Material material = GetMaterial(vMaterialId, vTexcoords);
    if(dot(material.m_emissivity, material.m_emissivity) > 0.0f)
        material.m_albedo = material.m_emissivity;  
    AlbedoOut = vec4(material.m_albedo, material.m_metallicity);
    NormalOut = vec4(0.5f * normal + 0.5f, material.m_roughness);
}

_kernel


void DebugRSM()
{
    if(vTexcoords.y > 0.5f)
    {
        if(vTexcoords.x < 0.5f)
        {
            
            const vec2 uv = 2.0f * vec2(vTexcoords.x, vTexcoords.y - 0.5f);
            FragColor = pow(texture(AlbedoBuffer, uv), vec4(1.0f / 2.2f));
        }
        else
        {
            
            const vec2 uv = 2.0f * vTexcoords - 1.0f;
            FragColor = texture(NormalBuffer, uv);
        }
    }
    else
    {
        if(vTexcoords.x < 0.5f)
        {
            
            const vec2 uv = 2.0f * vec2(vTexcoords.x, vTexcoords.y);
            const float metallicity = texture(AlbedoBuffer, uv).w;
            const float roughness = texture(NormalBuffer, uv).w;
            FragColor = vec4(roughness, metallicity, 0.0f, 1.0f);
        }
        else
        {
            
            const vec2 uv = 2.0f * vec2(vTexcoords.x - 0.5f, vTexcoords.y);
            FragColor = vec4(pow(texture(DepthBuffer, uv).x, 30.0f));
        }
    }
    FragColor = vec4(GetPassthruColor(FragColor.xyz), 1.0f);
}
